# -*- coding: utf-8 -*-
from os.path import dirname, join
import yaml


def slides_config(key=None):
    with open(join((dirname(__file__)), 'slides.yml')) as fd:
        if key:
            return yaml.load(fd)[key]
        else:
            return yaml.load(fd)


def get_slide_config(template, keys_to_format, **kwargs):
    for k, v in kwargs.iteritems():
        keys_to_format[k] = u'{}'.format(v)
    return format_conf(template, keys_to_format)


def format_conf(template, keys_to_format):
    conf = {}

    for k, v in template.iteritems():
        conf[k] = v
        if type(v) == bool:
            continue
        elif type(v) == dict:
            conf[k] = format_conf(v, keys_to_format)
        elif type(v) == list:
            new_v = [unicode(x).format(**keys_to_format) for x in v]
            conf[k] = new_v
        else:
            conf[k] = unicode(v).format(**keys_to_format)

    return conf
