# -*- coding: utf-8 -*-
import logging
from os.path import dirname, join
import re
import yaml
import os

logger = logging.getLogger(__name__)

with open(os.environ['SECRET_PATH']) as fd:
    SECRET = yaml.load(fd)
STAFF_URL = 'http://staff-api.yandex-team.ru/v3/'
SURVEY_URL = 'https://forms.yandex-team.ru/surveys/6071/'
TABLE_PATH = {
    'daily': '//home/vipplanners/users/i-anokhin/topview/daily',
    'weekly': '//home/vipplanners/users/i-anokhin/topview/weekly/total'
}

with open(join(dirname(__file__), 'queries', 'topview')) as fd:
    QUERY_TEMPLATE = fd.read().decode('utf-8')


PATTERN = re.compile(
    (r'\A####\n'
     r'(?P<type>.*?)\n'
     r'####\n'
     r'(?P<field_1>.*?)\n'
     r'####\n'
     r'(?P<client>.*?)\n'
     r'####\n'
     r'(?P<field_2>.*?)\n'
     r'####\n'
     r'(?P<competitors>.*?)\n'
     r'####\n'
     r'(?P<ppt_options>.*?)\n'
     r'####.*\Z'),
    flags=re.DOTALL)
