# -*- coding: utf-8 -*-
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
import smtplib


def send_email(from_, password, to, subject, message):
    msg = MIMEMultipart('alternative')
    text = MIMEText(message, 'html', 'utf8')

    msg['From'], msg['To'] = from_, ', '.join(to)
    msg['Subject'] = subject
    msg.attach(text)

    conn = smtplib.SMTP_SSL('smtp.yandex-team.ru', 465)
    conn.set_debuglevel(False)
    conn.login(from_, password)

    try:
        conn.sendmail(from_, to, msg.as_string())
    finally:
        conn.close()


def get_ordered_set(list_with_duplicates):
    ordered_set = []
    [ordered_set.append(elem) for elem in list_with_duplicates if elem not in ordered_set]
    return ordered_set


def normalize_login(login):
    return login.lower().replace('.', '-')


def replace_clids(logins, clids):
    for i, login in enumerate(logins):
        if login.isnumeric():
            logins[i] = clids.get(login, clids.get(int(login), {})).get('Login', login)
    return logins
