/* https://st.yandex-team.ru/OKK-3284
*/
USE hahn;

$last_cube_date = (
SELECT MAX(Cast(TableName(Path) AS Date))
FROM FOLDER(`//home/comdep-cubes/direct/production/hypercubes/clients`, `table`)
);

$LAG = 7;
$MIN_DATE = EvaluateExpr(CAST($last_cube_date - DateTime::IntervalFromDays(20) AS String));
$MAX_DATE = EvaluateExpr(Cast($last_cube_date AS String));

$date_to_sec = ($x) -> {
  $date = CAST($x AS Date);
  RETURN DateTime::ToSeconds($date);
};

$nvl = ($num) -> {
  RETURN NVL($num, 0);
};

-- настройки клиента на день анализа
INSERT INTO @client_features WITH TRUNCATE
SELECT * WITHOUT cube_date
FROM (
SELECT
    client_id
  , cube_date
  -- cost
  , cost
  , ListLength(
      ListFilter(
        AsList(
          $nvl(LAG(cost, 0) OVER client_w), $nvl(LAG(cost, 1) OVER client_w), $nvl(LAG(cost, 2) OVER client_w),
          $nvl(LAG(cost, 3) OVER client_w), $nvl(LAG(cost, 4) OVER client_w), $nvl(LAG(cost, 5) OVER client_w),
          $nvl(LAG(cost, 6) OVER client_w), $nvl(LAG(cost, 7) OVER client_w)
        )
      , ($x) -> {RETURN $x > 100}
      )
    ) AS active_days
  , ListAvg(
      AsList(
        $nvl(LAG(cost, 0) OVER client_w), $nvl(LAG(cost, 1) OVER client_w), $nvl(LAG(cost, 2) OVER client_w),  
        $nvl(LAG(cost, 3) OVER client_w), $nvl(LAG(cost, 4) OVER client_w), $nvl(LAG(cost, 5) OVER client_w),
        $nvl(LAG(cost, 6) OVER client_w), $nvl(LAG(cost, 7) OVER client_w)
      )
    ) AS cost_avg
  , ListAvg(
      AsList(
        $nvl(LAG(cost, 0) OVER client_w), $nvl(LAG(cost, 1) OVER client_w), $nvl(LAG(cost, 2) OVER client_w),  
        $nvl(LAG(cost, 3) OVER client_w), $nvl(LAG(cost, 4) OVER client_w), $nvl(LAG(cost, 5) OVER client_w),
        $nvl(LAG(cost, 6) OVER client_w), $nvl(LAG(cost, 7) OVER client_w)
      )
    ) -
    ListAvg(
      AsList(
        $nvl(LAG(cost, 8) OVER client_w), $nvl(LAG(cost, 9) OVER client_w), $nvl(LAG(cost, 10) OVER client_w),  
        $nvl(LAG(cost, 11) OVER client_w), $nvl(LAG(cost, 12) OVER client_w), $nvl(LAG(cost, 13) OVER client_w),
        $nvl(LAG(cost, 14) OVER client_w), $nvl(LAG(cost, 15) OVER client_w)
      )
    ) AS cost_t
  , $nvl((1 - (LAG(search_cost, $LAG) OVER client_w) / search_cost)) AS search_cost_t
  , $nvl((1 - (LAG(desktop_cost, $LAG) OVER client_w) / desktop_cost)) AS desktop_cost_t
  -- orders
  , $nvl(metrika_orders) AS metrika_orders
  , $nvl(metrika_orders_pct) AS metrika_orders_pct
  , $nvl(metrika_orders - (LAG(metrika_orders, $LAG) OVER client_w)) AS metrika_orders_t
  , $nvl(orders) AS orders
  , $nvl(orders - (LAG(orders, $LAG) OVER client_w)) AS orders_t
  , $nvl(timetarget_orders) AS timetarget_orders
  , $nvl(timetarget_orders_pct) AS timetarget_orders_pct
  , $nvl(timetarget_orders - (LAG(timetarget_orders, $LAG) OVER client_w)) AS timetarget_orders_t
  , $nvl(drf_orders) AS drf_orders
  , $nvl(drf_orders_pct) AS drf_orders_pct
  , $nvl(drf_orders - (LAG(drf_orders, $LAG) OVER client_w)) AS drf_orders_t
  , $nvl(autobudget_orders) AS autobudget_orders
  , $nvl(autobudget_orders_pct) AS autobudget_orders_pct
  , $nvl(autobudget_orders - (LAG(autobudget_orders, $LAG) OVER client_w)) AS autobudget_orders_t
  , $nvl(day_budget_orders) AS day_budget_orders
  , $nvl(day_budget_orders_pct) AS day_budget_orders_pct
  , $nvl(day_budget_orders - (LAG(day_budget_orders, $LAG) OVER client_w)) AS day_budget_orders_t
  , $nvl(smart_orders) AS smart_orders
  , $nvl(smart_orders_pct) AS smart_orders_pct
  , $nvl(smart_orders - (LAG(smart_orders, $LAG) OVER client_w)) AS smart_orders_t
  , $nvl(mcb_orders) AS mcb_orders
  , $nvl(mcb_orders - (LAG(mcb_orders, $LAG) OVER client_w)) AS mcb_orders_t
  , $nvl(cpm_orders) AS cpm_orders
  , $nvl(cpm_orders - (LAG(cpm_orders, $LAG) OVER client_w)) AS cpm_orders_t
  , $nvl(text_orders) AS text_orders
  , $nvl(text_orders_pct) AS text_orders_pct
  , $nvl(text_orders - (LAG(text_orders, $LAG) OVER client_w)) AS text_orders_t
  , $nvl(good_domains_disabled_orders) AS good_domains_disabled_orders
  , $nvl(good_domains_disabled_orders_pct) AS good_domains_disabled_orders_pct
  , $nvl(good_domains_disabled_orders - (LAG(good_domains_disabled_orders, $LAG) OVER client_w)) AS good_domains_disabled_orders_t
  , $nvl(max_bid_capped_orders) AS max_bid_capped_orders
  , $nvl(max_bid_capped_orders_pct) AS max_bid_capped_orders_pct
  , $nvl(max_bid_capped_orders - (LAG(max_bid_capped_orders, $LAG) OVER client_w)) AS max_bid_capped_orders_t
  , $nvl(context_enabled_nondynamic_orders) AS context_enabled_nondynamic_orders
  , $nvl(context_enabled_nondynamic_orders - (LAG(context_enabled_nondynamic_orders, $LAG) OVER client_w)) AS context_enabled_nondynamic_orders_t
  , $nvl(week_budget_orders) AS week_budget_orders
  , $nvl(week_budget_orders_pct) AS week_budget_orders_pct
  , $nvl(week_budget_orders - (LAG(week_budget_orders, $LAG) OVER client_w)) AS week_budget_orders_t
  , $nvl(extended_geo_enabled_orders) AS extended_geo_enabled_orders
  , $nvl(extended_geo_enabled_orders_pct) AS extended_geo_enabled_orders_pct
  , $nvl(extended_geo_enabled_orders - (LAG(extended_geo_enabled_orders, $LAG) OVER client_w)) AS extended_geo_enabled_orders_t
  -- groups
  , $nvl(mobile_multipliers_groups) AS mobile_multipliers_groups
  , $nvl(mobile_multipliers_groups_pct) AS mobile_multipliers_groups_pct
  , $nvl(mobile_multipliers_groups - (LAG(mobile_multipliers_groups, $LAG) OVER client_w)) AS mobile_multipliers_groups_t
  , $nvl(retargeting_multipliers_groups) AS retargeting_multipliers_groups
  , $nvl(retargeting_multipliers_groups_pct) AS retargeting_multipliers_groups_pct
  , $nvl(retargeting_multipliers_groups - (LAG(retargeting_multipliers_groups, $LAG) OVER client_w)) AS retargeting_multipliers_groups_t
  , $nvl(demography_multipliers_groups) AS demography_multipliers_groups
  , $nvl(demography_multipliers_groups_pct) AS demography_multipliers_groups_pct
  , $nvl(demography_multipliers_groups - (LAG(demography_multipliers_groups, $LAG) OVER client_w)) AS demography_multipliers_groups_t
  , $nvl(retargeting_conditions_groups) AS retargeting_conditions_groups
  , $nvl(retargeting_conditions_groups_pct) AS retargeting_conditions_groups_pct
  , $nvl(retargeting_conditions_groups - (LAG(retargeting_conditions_groups, $LAG) OVER client_w)) AS retargeting_conditions_groups_t
  , $nvl(relevance_match_groups) AS relevance_match_groups
  , $nvl(relevance_match_groups_pct) AS relevance_match_groups_pct
  , $nvl(relevance_match_groups - (LAG(relevance_match_groups, $LAG) OVER client_w)) AS relevance_match_groups_t
  , $nvl(with_image_ad_groups) AS with_image_ad_groups
  , $nvl(with_image_ad_groups_pct) AS with_image_ad_groups_pct
  , $nvl(with_image_ad_groups - (LAG(with_image_ad_groups, $LAG) OVER client_w)) AS with_image_ad_groups_t
  , $nvl(with_mobile_groups) AS with_mobile_groups
  , $nvl(with_mobile_groups_pct) AS with_mobile_groups_pct
  , $nvl(with_mobile_groups - (LAG(with_mobile_groups, $LAG) OVER client_w)) AS with_mobile_groups_t
  , $nvl(with_cpc_video_groups) AS with_cpc_video_groups
  , $nvl(with_cpc_video_groups_pct) AS with_cpc_video_groups_pct
  , $nvl(with_cpc_video_groups - (LAG(with_cpc_video_groups, $LAG) OVER client_w)) AS with_cpc_video_groups_t
  , $nvl(rarely_loaded_groups) AS rarely_loaded_groups
  , $nvl(rarely_loaded_groups_pct) AS rarely_loaded_groups_pct
  , $nvl(rarely_loaded_groups - (LAG(rarely_loaded_groups, $LAG) OVER client_w)) AS rarely_loaded_groups_t
  -- banners
  , $nvl(video_addition_banners) AS video_addition_banners
  , $nvl(video_addition_banners_pct) AS video_addition_banners_pct
  , $nvl(video_addition_banners - (LAG(video_addition_banners, $LAG) OVER client_w)) AS video_addition_banners_t
  , $nvl(vcard_banners) AS vcard_banners
  , $nvl(vcard_banners_pct) AS vcard_banners_pct
  , $nvl(vcard_banners - (LAG(vcard_banners, $LAG) OVER client_w)) AS vcard_banners_t
  , $nvl(template_banners) AS template_banners
  , $nvl(template_banners_pct) AS template_banners_pct
  , $nvl(template_banners - (LAG(template_banners, $LAG) OVER client_w)) AS template_banners_t
  , $nvl(sitelinks_banners) AS sitelinks_banners
  , $nvl(sitelinks_banners_pct) AS sitelinks_banners_pct
  , $nvl(sitelinks_banners - (LAG(sitelinks_banners, $LAG) OVER client_w)) AS sitelinks_banners_t
  FROM RANGE(`//home/comdep-cubes/direct/production/hypercubes/clients`, $MIN_DATE, $MAX_DATE)
  WINDOW client_w AS (
    PARTITION BY client_id
    ORDER BY cube_date
  )
)
WHERE cube_date = $MAX_DATE
ORDER BY client_id
; COMMIT;

-- https://st.yandex-team.ru/OKK-3284#5d88d9f9122154001d449caf
PRAGMA Folder("etalon", "https://proxy.sandbox.yandex-team.ru/1140924300/etalon");
PRAGMA Folder("offer", "https://proxy.sandbox.yandex-team.ru/1140924300/offer");

$ETALON_MODELS = AsDict(
  (103, CatBoost::LoadModel(FilePath("etalon/103.cbm"))),
  (104, CatBoost::LoadModel(FilePath("etalon/104.cbm"))),
  (105, CatBoost::LoadModel(FilePath("etalon/105.cbm"))),
  (106, CatBoost::LoadModel(FilePath("etalon/106.cbm"))),
  (111, CatBoost::LoadModel(FilePath("etalon/111.cbm"))),
  (112, CatBoost::LoadModel(FilePath("etalon/112.cbm"))),
  (113, CatBoost::LoadModel(FilePath("etalon/113.cbm"))),
  (114, CatBoost::LoadModel(FilePath("etalon/114.cbm"))),
  (115, CatBoost::LoadModel(FilePath("etalon/115.cbm"))),
  (116, CatBoost::LoadModel(FilePath("etalon/116.cbm"))),
  (117, CatBoost::LoadModel(FilePath("etalon/117.cbm"))),
  (118, CatBoost::LoadModel(FilePath("etalon/118.cbm"))),
  (119, CatBoost::LoadModel(FilePath("etalon/119.cbm"))),
  (120, CatBoost::LoadModel(FilePath("etalon/120.cbm"))),
  (129, CatBoost::LoadModel(FilePath("etalon/129.cbm"))),
  (130, CatBoost::LoadModel(FilePath("etalon/130.cbm"))),
  (133, CatBoost::LoadModel(FilePath("etalon/133.cbm"))),
  (134, CatBoost::LoadModel(FilePath("etalon/134.cbm"))),
  (135, CatBoost::LoadModel(FilePath("etalon/135.cbm"))),
  (136, CatBoost::LoadModel(FilePath("etalon/136.cbm"))),
  (138, CatBoost::LoadModel(FilePath("etalon/138.cbm"))),
  (139, CatBoost::LoadModel(FilePath("etalon/139.cbm"))),
  (141, CatBoost::LoadModel(FilePath("etalon/141.cbm"))),
  (143, CatBoost::LoadModel(FilePath("etalon/143.cbm"))),
  (144, CatBoost::LoadModel(FilePath("etalon/144.cbm"))),
  (147, CatBoost::LoadModel(FilePath("etalon/147.cbm"))),
);

$OFFER_MODELS = AsDict(
  (103, CatBoost::LoadModel(FilePath("offer/103.cbm"))),
  (104, CatBoost::LoadModel(FilePath("offer/104.cbm"))),
  (105, CatBoost::LoadModel(FilePath("offer/105.cbm"))),
  (106, CatBoost::LoadModel(FilePath("offer/106.cbm"))),
  (111, CatBoost::LoadModel(FilePath("offer/111.cbm"))),
  (112, CatBoost::LoadModel(FilePath("offer/112.cbm"))),
  (113, CatBoost::LoadModel(FilePath("offer/113.cbm"))),
  (114, CatBoost::LoadModel(FilePath("offer/114.cbm"))),
  (115, CatBoost::LoadModel(FilePath("offer/115.cbm"))),
  (116, CatBoost::LoadModel(FilePath("offer/116.cbm"))),
  (117, CatBoost::LoadModel(FilePath("offer/117.cbm"))),
  (118, CatBoost::LoadModel(FilePath("offer/118.cbm"))),
  (119, CatBoost::LoadModel(FilePath("offer/119.cbm"))),
  (120, CatBoost::LoadModel(FilePath("offer/120.cbm"))),
  (129, CatBoost::LoadModel(FilePath("offer/129.cbm"))),
  (130, CatBoost::LoadModel(FilePath("offer/130.cbm"))),
  (133, CatBoost::LoadModel(FilePath("offer/133.cbm"))),
  (134, CatBoost::LoadModel(FilePath("offer/134.cbm"))),
  (135, CatBoost::LoadModel(FilePath("offer/135.cbm"))),
  (136, CatBoost::LoadModel(FilePath("offer/136.cbm"))),
  (138, CatBoost::LoadModel(FilePath("offer/138.cbm"))),
  (139, CatBoost::LoadModel(FilePath("offer/139.cbm"))),
  (141, CatBoost::LoadModel(FilePath("offer/141.cbm"))),
  (143, CatBoost::LoadModel(FilePath("offer/143.cbm"))),
  (144, CatBoost::LoadModel(FilePath("offer/144.cbm"))),
  (147, CatBoost::LoadModel(FilePath("offer/147.cbm"))),
);

$calc_prob = ($x) -> {
  RETURN NVL(Math::Exp($x) / (1. + Math::Exp($x)), 0.0);
};

$eval_model = ($models, $row) -> {
  $num_f = AsList(
      $row.cost,
      $row.active_days,
      $row.cost_avg,
      $row.cost_t,

      $row.search_cost_t,
      $row.desktop_cost_t,
      $row.metrika_orders,
      $row.metrika_orders_t,
      $row.orders,
      $row.orders_t,
      $row.timetarget_orders,
      $row.timetarget_orders_t,
      $row.drf_orders,
      $row.drf_orders_pct,
      $row.drf_orders_t,
      $row.autobudget_orders,
      $row.autobudget_orders_pct,
      $row.autobudget_orders_t,
      $row.day_budget_orders,
      $row.day_budget_orders_pct,
      $row.day_budget_orders_t,
      $row.smart_orders,
      $row.smart_orders_pct,
      $row.smart_orders_t,
      $row.mcb_orders,
      $row.mcb_orders_t,
      $row.cpm_orders,
      $row.cpm_orders_t,
      $row.text_orders,
      $row.text_orders_pct,
      $row.text_orders_t,
      $row.good_domains_disabled_orders,
      $row.good_domains_disabled_orders_pct,
      $row.good_domains_disabled_orders_t,
      $row.max_bid_capped_orders,
      $row.max_bid_capped_orders_pct,
      $row.max_bid_capped_orders_t,
      $row.context_enabled_nondynamic_orders,
      $row.context_enabled_nondynamic_orders_t,
      $row.week_budget_orders,
      $row.week_budget_orders_pct,
      $row.week_budget_orders_t,
      $row.extended_geo_enabled_orders,
      $row.extended_geo_enabled_orders_pct,
      $row.extended_geo_enabled_orders_t,

      $row.mobile_multipliers_groups,
      $row.mobile_multipliers_groups_pct,
      $row.mobile_multipliers_groups_t,
      $row.retargeting_multipliers_groups,
      $row.retargeting_multipliers_groups_pct,
      $row.retargeting_multipliers_groups_t,
      $row.demography_multipliers_groups,
      $row.demography_multipliers_groups_pct,
      $row.demography_multipliers_groups_t,
      $row.retargeting_conditions_groups,
      $row.retargeting_conditions_groups_pct,
      $row.retargeting_conditions_groups_t,
      $row.relevance_match_groups,
      $row.relevance_match_groups_pct,
      $row.relevance_match_groups_t,
      $row.with_image_ad_groups,
      $row.with_image_ad_groups_pct,
      $row.with_image_ad_groups_t,
      $row.with_mobile_groups,
      $row.with_mobile_groups_pct,
      $row.with_mobile_groups_t,
      $row.with_cpc_video_groups,
      $row.with_cpc_video_groups_pct,
      $row.with_cpc_video_groups_t,
      $row.rarely_loaded_groups,
      $row.rarely_loaded_groups_pct,
      $row.rarely_loaded_groups_t,

      $row.video_addition_banners,
      $row.video_addition_banners_pct,
      $row.video_addition_banners_t,
      $row.vcard_banners,
      $row.vcard_banners_pct,
      $row.vcard_banners_t,
      $row.template_banners,
      $row.template_banners_pct,
      $row.template_banners_t,
      $row.sitelinks_banners,
      $row.sitelinks_banners_pct,
      $row.sitelinks_banners_t,
    );

  $num_f = ListMap($num_f, ($x) -> {RETURN NVL(Cast($x AS Float), 0.f)});
  $cat_f = ListCreate(Int64);

  RETURN ToDict(ListMap(
      DictItems($models),
      ($kv) -> {RETURN AsTuple($kv.0, $calc_prob(CatBoost::Evaluate($kv.1, $num_f, $cat_f, 1 AS TargetCount)[0]))}
    ));
};

$probs = (
  SELECT
    client_id
  , $eval_model($OFFER_MODELS, TableRow()) AS offer
  , $eval_model($ETALON_MODELS, TableRow()) AS etalon
  FROM @client_features
);


INSERT INTO `//home/vipplanners/oracle/adv_settings` WITH TRUNCATE
SELECT *
FROM $probs
ORDER BY client_id
;
