# -*- coding: utf-8 -*-
from pptx.chart.data import ChartData
from pptx.enum.chart import (
    XL_CHART_TYPE,
    XL_TICK_LABEL_POSITION,
    XL_TICK_MARK
)
from pptx.util import Pt

from presentation import GIDES, RGBColors


def client_vs_comp_chart(data=None, num_format=None, placeholder=None):
    if not data:
        return None

    chart_data = create_chart_data(data)
    chart = placeholder.insert_chart(XL_CHART_TYPE.COLUMN_CLUSTERED, chart_data).chart

    chart = format_category_axis(chart)
    chart = format_value_axis(chart, num_format)
    chart = format_columns(chart, data)

    series = chart.series[1]

    text_frame = series.points[0].data_label.text_frame.paragraphs[0]
    run = text_frame.add_run()
    run.text = data.get('gain')
    run.font.name = GIDES['font_name']
    run.font.size = GIDES['font_size']

    return chart


def bagel_chart(data=None, placeholder=None):
    if not data:
        return None

    chart_data = create_chart_data(data)
    chart = placeholder.insert_chart(XL_CHART_TYPE.DOUGHNUT, chart_data).chart

    series = chart.series[0]

    for p_num, point in enumerate(series.points):
        format = point.format
        format.fill.solid()

        format.fill.fore_color.rgb = data['colors'][p_num]

        text_frame = point.data_label.text_frame.paragraphs[0]
        run = text_frame.add_run()
        run.text = data['data_labels'][p_num]
        run.font.name = GIDES['font_name']
        run.font.size = GIDES['font_size']
        if p_num < 2:
            run.font.color.rgb = RGBColors['white']

    chart_xml = chart.plots[0]._element
    holeSize = chart_xml.xpath('./c:holeSize')[0]
    holeSize.set('val', '60')

    chart.has_title = False
    chart.has_legend = False

    return chart


def create_chart_data(data):
    chart_data = ChartData()
    chart_data.categories = data.get('categories', None)

    for s_num, series in enumerate(data.get('series', []), 1):
        name = series.get('name', 'Series %i' % s_num)
        values = series.get('values', [])

        chart_data.add_series(name, values)

    return chart_data


def format_category_axis(chart):
    axis = chart.category_axis

    axis.has_major_gridlines = False
    axis.major_tick_mark = XL_TICK_MARK.NONE
    axis.tick_label_position = XL_TICK_LABEL_POSITION.NONE

    axis.format.line.color.rgb = RGBColors['black']
    axis.format.line.width = Pt(1)

    return chart


def format_value_axis(chart, num_format):
    axis = chart.value_axis

    axis.minimum_scale = 0

    axis.format.line.color.rgb = RGBColors['grey']
    axis.format.line.color.brightness = 1.0

    axis.major_gridlines.format.line.color.rgb = RGBColors['grey']
    axis.major_gridlines.format.line.width = Pt(1)

    axis.tick_labels.font.name = GIDES['font_name']
    axis.tick_labels.font.size = GIDES['font_size']
    axis.tick_labels.number_format = num_format

    return chart


def format_columns(chart, data):
    plt = chart.plots[0]
    plt.gap_width = 100
    plt.overlap = -25

    for s_num, series in enumerate(data.get('series', None)):
        fill = chart.series[s_num].format.fill
        fill.solid()

        chart.series[s_num].format.fill.fore_color.rgb = series.get('color', None)

    return chart
