# coding: utf-8
"""Settings"""
from codecs import open
from os import path
from subprocess import call
from setuptools import setup, find_packages, Command
from ta_report.const import __version__

PACKAGES = [
    "pandas >=0.18, <0.20",  # 0.20.rc1 - fail because of tar.gz
    "numpy < 1.17.0",
    "docopt >= 0.6",
    "xlsxwriter >= 1.0",
    "xlrd==1.0.0",
    "colorlog >= 3.0, <4.0",
    "pillow >= 3",
    "PyYAML >= 3.12",
    "python-pptx==0.6.13",
    "requests==2.22.0"
]

HERE = path.abspath(path.dirname(__file__))
with open(path.join(HERE, 'README.rst'), encoding='utf-8') as f:
    DESCRIPTION = f.read()


class RunTests(Command):
    """Run all tests."""
    description = 'run tests'
    user_options = []

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        """Run all tests!"""
        errno = call(['green', '-vv'])
        raise SystemExit(errno)


if __name__ == "__main__":
    setup(
        name="ta-report",
        description='CLI for Tehnoad',
        long_description=DESCRIPTION,
        version=__version__,
        packages=find_packages(exclude=["tests"]),
        include_package_data=True,
        package_data={'ta_report': ['*.yml', 'xlsx_chart/*.yml', 'pptx_ta/*.yml', 'pptx_ta/*.pptx', 'hide_comments.png']},
        install_requires=PACKAGES,
        extras_require={
            "dev": ["green"]
        },
        entry_points={
            "console_scripts": [
                'ta-report = ta_report.cli: main'
            ]
        },
        classifiers=[
            "Development Status :: 4 - Beta",
            "Environment :: Console",
            "Programming Language :: Python :: 2.7",
            "Topic :: Utilities"
        ],
        cmdclass={'test': RunTests}
    )
