# coding: utf-8
import json
from os.path import dirname, join
from pptx.dml.color import RGBColor
import yaml

from ..const import ARGS_FILE_PATH


# Порядок цветов для bar-чартов
COLORS = [
    RGBColor(255, 51, 51),
    RGBColor(255, 204, 0),
    RGBColor(0, 119, 255),
    RGBColor(35, 179, 36),
    RGBColor(93, 206, 249),

    RGBColor(198, 44, 208),
    RGBColor(255, 154, 0),
    RGBColor(255, 235, 153),
    RGBColor(255, 173, 173)
]

# Словарик с гайдовыми цветами
RGBColors = {
    'red': RGBColor(255, 51, 51),

    'yellow': RGBColor(255, 204, 0),
    'pale_yellow_1': RGBColor(255, 224, 102),
    'pale_yellow_2': RGBColor(255, 245, 204),

    'blue': RGBColor(0, 119, 255),
    'green': RGBColor(35, 179, 36),

    'black': RGBColor(0, 0, 0),
    'white': RGBColor(255, 255, 255),
    'grey': RGBColor(217, 217, 217),
    'dark_grey': RGBColor(191, 191, 191)
}


def return_pptx_name():
    with open(ARGS_FILE_PATH) as fd_:
        args = json.load(fd_)
    lang = args.get('--lang', None)

    if lang is None:
        return PPTX_YML['presentation']['meta']['en_name']
    else:
        return PPTX_YML['presentation']['meta']['ru_name']


PPTX_GIDES = {
    'font_name': 'Arial',
    'font_size': 24,
    'table_font_size': 20
}

with open(join(dirname(__file__), 'pptx_config.yml')) as fd:
    PPTX_YML = yaml.load(fd)
