# coding: utf-8


def _add_ratio(df, ratio_type, numerator, denominator, suffix):
    ratio_name = "{}{}".format(ratio_type, suffix)
    num_name = "{}{}".format(numerator, suffix)
    den_name = "{}{}".format(denominator, suffix)
    df[ratio_name] = df[num_name] / df[den_name]

    return df


_add_cpc = lambda df, suffix: _add_ratio(df, "CPC", "Cost", "Clicks", suffix)
_add_ctr = lambda df, suffix: _add_ratio(df, "CTR", "Clicks", "Shows", suffix)

add_cpc_search = lambda df: _add_cpc(df, "Search")
add_cpc_spec = lambda df: _add_cpc(df, "Spec")
add_cpc_other = lambda df: _add_cpc(df, "Other")
add_cpc_rsya = lambda df: _add_cpc(df, "RSYA")
add_cpc_mobile = lambda df: _add_cpc(df, "Mobile")
add_cpc_desktop = lambda df: _add_cpc(df, "Desktop")
add_cpc_total = lambda df: _add_cpc(df, "")

add_ctr_search = lambda df: _add_ctr(df, "Search")
add_ctr_spec = lambda df: _add_ctr(df, "Spec")
add_ctr_other = lambda df: _add_ctr(df, "Other")
add_ctr_rsya = lambda df: _add_ctr(df, "RSYA")
add_ctr_mobile = lambda df: _add_ctr(df, "Mobile")
add_ctr_desktop = lambda df: _add_ctr(df, "Desktop")
add_ctr_total = lambda df: _add_ctr(df, "")

__ALL__ = [
    add_cpc_search,
    add_cpc_spec,
    add_cpc_other,
    add_cpc_rsya,
    add_cpc_mobile,
    add_cpc_desktop,
    add_cpc_total,
    add_ctr_search,
    add_ctr_spec,
    add_ctr_other,
    add_ctr_rsya,
    add_ctr_mobile,
    add_ctr_desktop,
    add_ctr_total
]
