# coding: utf-8
"""xlsx-keywords:
  - 05_words_cnt
  - 13_top_words_usage
  - 13_top_words_uppercase
"""
from .utils import (
    add_cpc_search,
    add_ctr_search,
)
import pandas as pd


def table_words_cnt(df, normalize):
    """05_words_cnt"""

    words_cnt = sorted(set(df.WordsCnt.unique()) | set(range(1, 8)))

    df_chart = (df[(df.ShowsSearch > 0)]
                .loc[:, ["ShowsSearch", "ClicksSearch", "CostSearch", "BSPhraseID", "WordsCnt"]]
                .groupby("WordsCnt")
                .agg({
                    "ShowsSearch": pd.np.sum,
                    "ClicksSearch": pd.np.sum,
                    "CostSearch": pd.np.sum,
                    "BSPhraseID": lambda x: x.unique().size}))

    if df_chart.shape[0] == 0:
        return None

    add_cpc_search(df_chart)
    add_ctr_search(df_chart)
    df_chart.rename(
        columns={
            "BSPhraseID": u"Кол-во фраз",
            "ShowsSearch": u"Показы (поиск)",
            "ClicksSearch": u"Клики (поиск)",
            "CostSearch": u"Расходы (поиск)",
            "CPCSearch": u"CPC (поиск)",
            "CTRSearch": u"CTR (поиск)"
        },
        inplace=True)
    df_chart.index.name = u"Кол-во слов во фразе"

    df_chart = df_chart.loc[words_cnt].fillna(pd.np.nan)

    if normalize:
        sum_col = [u"Кол-во фраз", u"Показы (поиск)", u"Клики (поиск)", u"Расходы (поиск)"]
        max_col = [u"CPC (поиск)", u"CTR (поиск)"]
        df_chart.loc[:, sum_col] = df_chart.loc[:, sum_col].apply(lambda x: x / x.sum())
        df_chart.loc[:, max_col] = df_chart.loc[:, max_col].apply(lambda x: x / x.max())

    df_chart = df_chart.loc[:, [u"Кол-во фраз",
                                u"Показы (поиск)",
                                u"Расходы (поиск)",
                                u"Клики (поиск)",
                                u"CPC (поиск)",
                                u"CTR (поиск)"]]

    if normalize:
        formats = {
            u"Кол-во фраз": "percent",
            u"Показы (поиск)": "percent",
            u"Расходы (поиск)": "percent",
            u"Клики (поиск)": "percent",
            u"CPC (поиск)": "float",
            u"CTR (поиск)": "float"}
    else:
        formats = {
            u"Кол-во фраз": "int",
            u"Показы (поиск)": "int",
            u"Расходы (поиск)": "int",
            u"Клики (поиск)": "float",
            u"CPC (поиск)": "float",
            u"CTR (поиск)": "percent"}

    setattr(df_chart, "formats", formats)

    return df_chart
