# coding: utf-8
"""xlsx-mobile"""
from .campaign_stat import (
    table_total_campaigns_stat,
    table_used_strategies_report,
    table_campaigns_type,
    table_list_campaigns_type,
    plot_campaigns_type,
    plot_campaigns_type_ctr_cpc
)
from .highlight import (
    table_highlight_type_phrases,
    plot_highlight_type_phrases,
    plot_highlight_type_phrases_p,
    plot_highlight_type_phrases_cpc_ctr,
    table_highlight_hist,
    plot_highlight_hist,
    table_highlight_type_campaign
)
from .phrases import (
    table_top_nonbolded_phrases,
    table_top_phrases_lost_clicks,
    table_top_phrases_strange_pos,
    table_top_cpc_phrases
)
from .banners import (
    table_top_banners_has_uppercase
)
from .words import (
    table_words_cnt,
    plot_words_cnt,
    plot_words_cnt_ctr_cpc,
    table_top_words_uppercase,
    table_top_words_usage
)
from .templates import (
    table_templates_incorrect_usage,
    table_templates_status,
    plot_templates_status,
    plot_templates_status_ctr_cpc
)
from .img_shapes import (
    table_img_shapes,
    table_rsya_banners_wo_img
)
from .timetarget import (
    table_avg_time_target,
    use_time_target_campaigns
)
from .group_stat import table_group_stat_distribution
from ..configure_reports import CLI_REPORTS_CONFIG, return_show_comments, return_sheet_name, return_sheet_note
from ..xlsx_chart.chart import colorize_table_rows
from ..utils import (
    get_report_meta,
    save_report_meta,
    add_sheet_to_xlsx,
    note_maker as note
)


def make_builder(fn, sheet_name, sheet_fmt=None, **kw_args):
    """((DataFrame) -> DataFrame, str, [(ExcelWriter, str, DataFrame) -> ExcelWriter], **kw_args) ->
       ((ExcelWriter, DataFrame) -> ExcelWriter)"""
    if sheet_fmt is None:
        sheet_fmt = []
    if not isinstance(sheet_fmt, list):
        raise TypeError("`sheet_fmt` must be iterable or None")

    sheet_note = return_sheet_note("mobile", sheet_name, **kw_args)
    if sheet_note:
        sheet_fmt += [note(sheet_note)]

    if kw_args.get("sheet_writer"):
        sheet_writer = kw_args["sheet_writer"]
    else:
        sheet_writer = add_sheet_to_xlsx

    def builder(writer, df):
        data_to_save = fn(df)
        if not isinstance(data_to_save, dict) and data_to_save is not None:
            setattr(data_to_save, "show_comments", return_show_comments("mobile"))

        sheet_writer(writer, data_to_save, sheet_name=return_sheet_name("mobile", sheet_name),
                     sheet_fmt=sheet_fmt, **kw_args)

    return builder


def return_mobile_builder(sheet_name):

    if sheet_name == "_Info":
        return [make_builder(get_report_meta,
                             "_Info",
                             sheet_writer=save_report_meta)]

    elif sheet_name == "00_total_campaigns_stat":
        return [make_builder(table_total_campaigns_stat,
                             "00_total_campaigns_stat",
                             index=None)]

    elif sheet_name == "00_used_strategies":
        return [make_builder(table_used_strategies_report,
                             "00_used_strategies",
                             index=None)]

    elif sheet_name == "01_highlight_type":
        return [
            make_builder(
                lambda df: table_highlight_type_phrases(df, normalize=False),
                "01_highlight_type",
                sheet_fmt=[lambda w, sh, df: plot_highlight_type_phrases(w, sh, cell="A7", df=df),
                           plot_highlight_type_phrases_cpc_ctr]
            ),
            make_builder(
                lambda df: table_highlight_type_phrases(df, normalize=True),
                "01_highlight_type",
                startcol=9,
                sheet_fmt=[lambda w, sh, df: plot_highlight_type_phrases_p(w, sh, cell="P7", df=df)]
            )
        ]

    elif sheet_name == "01_highlight_hist":
        return [
            make_builder(lambda df: table_highlight_hist(df, normalize=False),
                         "01_highlight_hist",
                         startcol=9
                         ),
            make_builder(lambda df: table_highlight_hist(df, normalize=True),
                         "01_highlight_hist",
                         sheet_fmt=[plot_highlight_hist]
                         )
        ]

    elif sheet_name == "01_campaign_highlight_type":
        return [make_builder(table_highlight_type_campaign,
                             "01_campaign_highlight_type")]

    elif sheet_name == "01_top_non-bolded_phrases":
        return [make_builder(table_top_nonbolded_phrases,
                             "01_top_non-bolded_phrases",
                             index=None)]

    elif sheet_name == "03_top_banners_has_uppercase":
        return [make_builder(table_top_banners_has_uppercase,
                             "03_top_banners_has_uppercase",
                             index=None)]

    elif sheet_name == "04_campaigns_type":
        return [
            make_builder(lambda df: table_campaigns_type(df, normalize=True),
                         "04_campaigns_type"
                         ),
            make_builder(lambda df: table_campaigns_type(df, normalize=False),
                         "04_campaigns_type",
                         startcol=9,
                         sheet_fmt=[plot_campaigns_type, plot_campaigns_type_ctr_cpc]
                         )
        ]

    elif sheet_name == "04_list_campaigns_type":
        return [make_builder(table_list_campaigns_type,
                             "04_list_campaigns_type",
                             index=None)]

    elif sheet_name == "05_words_cnt":
        return [
            make_builder(lambda df: table_words_cnt(df, normalize=False),
                         "05_words_cnt",
                         startcol=9
                         ),
            make_builder(lambda df: table_words_cnt(df, normalize=True),
                         "05_words_cnt",
                         sheet_fmt=[plot_words_cnt, plot_words_cnt_ctr_cpc]
                         )
        ]

    elif sheet_name == "06_templates_status":
        return [
            make_builder(lambda df: table_templates_status(df, normalize=True),
                         "06_templates_status"
                         ),
            make_builder(lambda df: table_templates_status(df, normalize=False),
                         "06_templates_status",
                         startcol=10,
                         sheet_fmt=[plot_templates_status, plot_templates_status_ctr_cpc]
                         )
        ]

    elif sheet_name == "06_templates_incorrect_usage":
        return [make_builder(table_templates_incorrect_usage,
                             "06_templates_incorrect_usage")]

    elif sheet_name == "08_img_shapes":
        return [make_builder(table_img_shapes,
                             "08_img_shapes",
                             index=None)]

    elif sheet_name == "09_rsya_banners_wo_img":
        return [make_builder(table_rsya_banners_wo_img,
                             "09_rsya_banners_wo_img")]

    elif sheet_name == "10_avg_time_target":
        return [make_builder(table_avg_time_target,
                             "10_avg_time_target",
                             sheet_fmt=[lambda ws, sh, _: colorize_table_rows(ws, sh, 1, 2, 7, 25)]
                             )
                ]

    elif sheet_name == "10_use_time_target_campaigns":
        return [make_builder(use_time_target_campaigns,
                             "10_use_time_target_campaigns",
                             index=None)]

    elif sheet_name == "11_top_phrases_lost_clicks":
        return [make_builder(table_top_phrases_lost_clicks,
                             "11_top_phrases_lost_clicks",
                             index=None)]

    elif sheet_name == "12_top_phrases_strange_pos":
        return [make_builder(table_top_phrases_strange_pos,
                             "12_top_phrases_strange_pos",
                             index=None)]

    elif sheet_name == "13_top_cpc_phrases":
        return [make_builder(table_top_cpc_phrases,
                             "13_top_cpc_phrases",
                             index=None)]

    elif sheet_name == "12_group_stat_distribution":
        return [make_builder(table_group_stat_distribution,
                             "12_group_stat_distribution")]

    elif sheet_name == "13_top_words_usage":
        return [make_builder(table_top_words_usage,
                             "13_top_words_usage")]

    elif sheet_name == "13_top_words_uppercase":
        return [make_builder(table_top_words_uppercase,
                             "13_top_words_uppercase")]

    else:
        return []


def make_xlsx_mobile(sheets):
    sheets = [sheet_name for sheet_name in CLI_REPORTS_CONFIG["mobile"]["meta"]["sheet_names"]
              if sheet_name in sheets]
    xlsx_mobile = [return_mobile_builder(sheet_name) for sheet_name in sheets]
    return sum(xlsx_mobile, [])
