# coding: utf-8
"""xlsx-mobile:
 - 03_top_banners_has_uppercase

Help:
В РМП у объявлений нет быстрых ссылок, уточнений, описаний.
[Quick Links](https://yandex.ru/support/direct/features/quick-links.xml) (Search)
[Callouts](https://yandex.ru/support/direct/features/callout.xml?lang=ru) (Search)
[Описания](https://yandex.ru/support/direct-news/n-2015-10-26.xml) (Search)
"""
from ..const import EXCEL_MAX_ROWS
from ..utils import has_uppercase_word, filter_by_adtype
from .utils import (
    add_cpc_total,
    add_ctr_total
)
import pandas as pd


def table_top_banners_has_uppercase(df):
    """03_top_banners_has_uppercase"""

    df_chart = filter_by_adtype(df, "MOBILE_APP_AD")
    df_chart = df_chart[(df_chart["Shows"] > 0)][
        ["DirectBannerID", "Title", "Body", "Shows", "Clicks", "Cost"]].copy()
    if df_chart.shape[0] == 0:
        return None
    has_uppercase = (df_chart["Title"].apply(has_uppercase_word) | df_chart["Body"].apply(has_uppercase_word))
    df_chart = (df_chart[has_uppercase]
                .groupby(["DirectBannerID", "Title", "Body"], as_index=False)
                .agg({
                    "Shows": pd.np.sum,
                    "Clicks": pd.np.sum,
                    "Cost": pd.np.sum})
                .sort_values("Shows", ascending=False)
                .head(EXCEL_MAX_ROWS))

    add_cpc_total(df_chart)
    add_ctr_total(df_chart)

    if df_chart.shape[0] == 0:
        return None
    else:
        return df_chart.loc[:, ["DirectBannerID",
                                "Title",
                                "Body",
                                "Shows",
                                "Clicks",
                                "Cost",
                                "CPC",
                                "CTR"]]
