# coding: utf-8
"""xlsx-mobile: 12_group_stat_distribution"""
from .utils import (
    add_cpc_total,
    add_ctr_total
)
import pandas as pd


def table_group_stat_distribution(df):
    "12_group_stat_distribution"

    df_chart = (df[["GroupID", "DirectPhraseID", "Shows", "Clicks", "Cost"]]
                .groupby("GroupID", as_index=False)
                .agg({"Shows": pd.np.sum,
                      "Clicks": pd.np.sum,
                      "Cost": pd.np.sum,
                      "DirectPhraseID": lambda x: x.unique().size})
                .groupby("DirectPhraseID")
                .sum()
                [["Shows", "Clicks", "Cost"]]
                .sort_index())

    if df_chart.shape[0] == 0:
        return None

    add_cpc_total(df_chart)
    add_ctr_total(df_chart)

    df_chart.rename(columns={
        "Shows": u"Показы",
        "Clicks": u"Клики",
        "Cost": u"Затраты",
        "CPC": u"CPC",
        "CTR": u"CTR"},
        inplace=True)

    df_chart.index.names = [u"Кол-во фраз в группе"]

    return df_chart.loc[:, [u"Показы",
                            u"Клики",
                            u"Затраты",
                            u"CPC",
                            u"CTR"]]
