# coding: utf-8
"""new cpc for search-query"""

from .calc import (get_reference, make_cached_nearest_vals_from_reference)

# dict<phrase_words_cnt, dict<imp_cnt, coeff> >
CPC_IMPROVEMENT = {
    1: {1: 1.0, 2: 1.0, 3: 1.0, 4: 1.0, 5: 1.0, 6: 1.0},
    2: {1: 1.0, 2: 1.0, 3: 1.0, 4: 1.0, 5: 1.0},
    3: {1: 1.0, 2: 1.0, 3: 1.0, 4: 1.0},
    4: {1: 1.0, 2: 1.0, 3: 1.0},
    5: {1: 1.0, 2: 1.0},
    6: {1: 1.0}}

# dict<tuple(phrase_words_cnt, improvement_len), improvement_cpc>
CPC_IMPROVEMENT = {(p, i): CPC_IMPROVEMENT[p][i] for p in CPC_IMPROVEMENT for i in CPC_IMPROVEMENT[p]}

# When CPC ~ CTR^-1
# from .new_ctr import CTR_IMPROVEMENT
# CPC_IMPROVEMENT = {k: val**-1 for k, val in CTR_IMPROVEMENT.iteritems()}


nearest_vals_from_reference = make_cached_nearest_vals_from_reference()


def calc_weighted_cpc(reference, row):

    CONFEDENCE_L = 100.0  # Clicks

    ref = nearest_vals_from_reference(
        reference,
        row["PhraseWordsCnt"],
        row["QueryWordsCnt"])
    ref_cpc = ref["Cost"] / ref["Clicks"]

    if row["Clicks"]:
        fact_cpc = row["Cost"] / float(row["Clicks"])
    else:
        fact_cpc = 0.0

    confedence = min(row["Clicks"], CONFEDENCE_L) / float(CONFEDENCE_L)

    return fact_cpc * confedence + ref_cpc * (1 - confedence)


def new_cpc(improvements, reference, row):

    imp_cnt = max(0, min(row["QueryWordsCnt"], 7) - min(row["PhraseWordsCnt"], 7))

    if imp_cnt == 0:
        if row["Clicks"]:
            new_cpc = row["Cost"] / float(row["Clicks"])
        else:
            new_cpc = 0.0
    else:
        change_coef = improvements[(min(row["PhraseWordsCnt"], 6), imp_cnt)]
        new_cpc = calc_weighted_cpc(reference, row) * change_coef

    return new_cpc


def new_cpc_col(df):

    REFERENCE = get_reference(df, shows=100, clicks=10)
    new_cpc_for_row = lambda row: new_cpc(CPC_IMPROVEMENT, REFERENCE, row)

    return df.apply(new_cpc_for_row, axis=1)
