# -*- coding: utf-8 -*-
from os.path import join, dirname
import re
import yaml
import os


with open(os.environ['SECRET_PATH']) as fd:
    SECRET = yaml.load(fd)

with open(join(dirname(__file__), 'config.yml')) as fd:
    CONFIG = yaml.load(fd)
    CONFIG['yt_tables_path'] = CONFIG['yt_tables_path'].format(secret_login=SECRET['PASSPORT']['login'])

USER_VARS = {
    'SEARCH_QUERIES_REV': '5515943',
    'SEARCH_QUERIES_REV_SYN': 1,
    'SEARCH_QUERIES_REV_AGG': '6138668',
    'SEARCH_QUERIES_REV_AGG_SYN': 1
}

PATTERN = re.compile(
    r'\A####\n'
    r'(?P<type>.*?)\n'
    r'####\n'
    r'(?P<cs_params>.*?)####\n'
    r'(?P<logins>.*?)\n'
    r'####\n'
    r'####\n'
    r'(?P<cids>.*?)\n'
    r'####\n'
    r'(?P<ta_params>.*?)\n'
    r'####.*\Z',
    flags=re.DOTALL)
