# -*- coding: utf-8 -*-
import os
import re
import yaml


with open(os.environ['SECRET_PATH']) as fd:
    secret = yaml.load(fd)

filters = {
    'queue': 'CSSUPPORT',
    'assignee': 'me()',
    'tags': ['highlight', 'validated'],
    'status': {'id': 1},
    'components': {'id': 30835}
}

ticket_pattern_new = re.compile(
    (r'\A####\n'
     r'(?P<type>.*?)\n'
     r'####\n'
     r'(?P<setup>.*?)####\n'
     r'(?P<logins>.*?)\n'
     r'####\n'
     r'####\n'
     r'(?P<cids>.*?)\n'
     r'####\n'
     r'(?P<params>.*?)\n'
     r'####.*\Z'
     ),
    flags=re.DOTALL)

ticket_pattern_old = re.compile(
    (r'\A####\n'
     r'(?P<type>.*)\n'
     r'####\n'
     r'(?P<setup>.*)####\n'
     r'(?P<logins>.*)\n'
     r'####\n'
     r'(?P<comment>.*)\Z'),
    flags=re.DOTALL)
