/* Запрос "Все что есть для списка логинов [и кампаний]
Интерфейс по параметрам и формату результата максимально близок к
https://a.yandex-team.ru/arc/trunk/arcadia/client_analytics/ta_report_yql/search_queries.sql?rev=4248437

Но search_queries.{info, errors} скопированы как есть и для выборки не вычисляются
*/

USE hahn;

PRAGMA yt.QueryCacheMode = "normal";
PRAGMA yt.QueryCacheIgnoreTableRevision = "true";
PRAGMA yt.DefaultMaxJobFails = "15";
PRAGMA yt.DataSizePerJob = "10G";

DECLARE $TASK_AUTHOR_LOGIN AS String;
DECLARE $YT_BASE_PATH AS String;
DECLARE $YT_TASK_FOLDER AS String;
DECLARE $LOGINS AS List<String>;
DECLARE $CAMPAIGN_IDS_WL AS List<Uint64>;
DECLARE $PERIOD_SIZE_D AS Uint8;
DECLARE $YT_FOLDER_SRCS AS String;

/* Определение параметров для теста */
-- $TASK_AUTHOR_LOGIN = "n-bar";  -- в чьем пуле запускать
-- $YT_BASE_PATH = "//tmp/ta_report";  -- корневая папка с результаттами
-- $YT_TASK_FOLDER = "TTT-1";  -- папка с результатами конкретного задания
-- $LOGINS = AsList("RRU-ya-A-Cities", "RU-ya-C-Cities", "RU-ya-B-Cities", "RU-ya-Misc", "RU-ya-A-Cities");
-- $CAMPAIGN_IDS_WL = AsList(12925781, 12751209, 12925751);

$YT_REPORT_TYPE = "search_queries";
$YT_FOLDER_PATH_SRC = "//home/vipplanners/ta_report";
$PERIOD_SIZE_D = 30;

$YT_FULL_PATH_SRC = $YT_FOLDER_PATH_SRC || '/' || Cast($PERIOD_SIZE_D AS String) || 'd';
$YT_FULL_PATH_SRC_RESULT = $YT_FULL_PATH_SRC || '/' || $YT_REPORT_TYPE || ".data";
$YT_FULL_PATH_SRC_ERRORS = $YT_FULL_PATH_SRC || '/' || $YT_REPORT_TYPE || ".errors";
$YT_FULL_PATH_SRC_INFO   = $YT_FULL_PATH_SRC || '/' || $YT_REPORT_TYPE || ".info";

$YT_FULL_PATH_DST = $YT_BASE_PATH || '/' || $YT_TASK_FOLDER || '/' || $YT_REPORT_TYPE;
$YT_FULL_PATH_DST_RESULT = $YT_FULL_PATH_DST || ".data";
$YT_FULL_PATH_DST_ERRORS = $YT_FULL_PATH_DST || ".errors";
$YT_FULL_PATH_DST_INFO   = $YT_FULL_PATH_DST || ".info";

PRAGMA yt.Owners = "n-bar leroy";
PRAGMA yt.Pool = $TASK_AUTHOR_LOGIN;


$normalize_login = ($x) -> {
    RETURN String::ReplaceAll(String::ToLower($x), ".", "-");
};
$_LOGINS = EvaluateExpr(ListMap($LOGINS, $normalize_login));
$LOGINS = EvaluateCode(ListCode(ListMap($_LOGINS, ($i)->{return ReprCode($i)})));

$HAS_CID_WL = EvaluateExpr(ListLength($CAMPAIGN_IDS_WL) > 0);

$CLIENT_IDS = (
    SELECT DISTINCT ClientID
    FROM `//home/direct/db/users`
    WHERE $normalize_login(login) IN COMPACT $LOGINS
);

INSERT INTO $YT_FULL_PATH_DST_RESULT WITH TRUNCATE
SELECT *
FROM $YT_FULL_PATH_SRC_RESULT
WHERE 
      ClientID IN COMPACT $CLIENT_IDS
  AND IF(
    $HAS_CID_WL,
    CampaignID IN COMPACT EvaluateCode(ListCode(ListMap($CAMPAIGN_IDS_WL, ($i)->{return ReprCode($i)}))),
    True
  )
ORDER BY ClientID, CampaignID
;

INSERT INTO $YT_FULL_PATH_DST_ERRORS WITH TRUNCATE
SELECT * FROM $YT_FULL_PATH_SRC_ERRORS
;
INSERT INTO $YT_FULL_PATH_DST_INFO WITH TRUNCATE
SELECT * FROM $YT_FULL_PATH_SRC_INFO
; COMMIT;

SELECT * FROM $YT_FULL_PATH_DST_ERRORS;
SELECT * FROM $YT_FULL_PATH_DST_INFO;

