# -*- coding: utf-8 -*-
"""
Usage:
    weekly-pack <artmon_token> <token>

Options:
    -h --help     Show this screen.
"""
from docopt import docopt
import logging
from logging.config import dictConfig
import yaml
import warnings
from weekly_pack.utils import get_file
warnings.filterwarnings('ignore')

with get_file('logger.yml') as fd:
    dictConfig(yaml.load(fd))

logger = logging.getLogger(__name__)


def main():
    args = docopt(__doc__)
    with open(u'user_secret.yml', 'w') as fd:
        yaml.dump({'artmon_token': args['<artmon_token>'], 'token': args['<token>']}, fd)

    from data.make_xlsx import run_data_workers
    run_data_workers()


if __name__ == '__main__':
    main()
