$format = ($date) -> {
    $parse = DateTime::Parse('%Y%m');
    RETURN DateTime::Format('%Y-%m-%d')(Datetime::MakeDate($parse($date)))
};

SELECT 
    `Month`,
    Category_Name,
    SUM(reward) AS Total, -- / COUNT(DISTINCT category_id) 
    SUM(reward_of_category) AS reward_of_category
FROM (
    SELECT 
        yyyymm,
        reward,
        category_id,
        reward_of_category,
        amt_total
    FROM hahn.`//home/search-research/ga/bonus_cashback/dash/datasets/active_base_v3.5`
    WHERE currency IN ('RUR')
)
--WHERE category_id IN (2, 3, 4)
GROUP BY
    $format(yyyymm) AS `Month`,
    CASE 
            WHEN category_id = 0 THEN 'Корректировки'
            WHEN category_id = 2 THEN 'РМП'
            WHEN category_id = 3 THEN 'Aвтостратегии (старые)'
            WHEN category_id = 4 THEN 'КЦ Метрики'
            WHEN category_id = 5 THEN 'Автотаргетинг'
            WHEN category_id = 6 THEN 'Ретаргетинг'
            WHEN category_id = 7 THEN 'Маркет (старый)'
            WHEN category_id = 8 THEN 'ДРР'
            WHEN category_id = 9 THEN 'Еком'
            WHEN category_id = 10 THEN 'Видео'
            WHEN category_id = 11 THEN 'Автостратегии (новые)'
            WHEN category_id = 12 THEN 'Маркет (новый)'
            ELSE ''
        END AS Category_Name