PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$week = ($date) -> {
    return DateTime::Format("%Y-%m-%d")(DateTime::StartOfWeek(cast($date as Date)))
};

SELECT 
    SUM(CAST(cost AS Int64)) AS Cost,
    Week,
    'Массажное обордуование' AS `Group`
FROM hahn.`//home/antivir/osynskyi/massage_equipment_tst`
GROUP BY $week(day) AS Week
UNION ALL 
SELECT 
    SUM(CAST(cost AS Int64)) AS Cost,
    Week,
    'Всего' AS `Group`
FROM hahn.`//home/antivir/osynskyi/total_week`
GROUP BY week AS Week
UNION ALL
SELECT 
    SUM(CAST(cost AS Int64)) AS Cost,
    Week,
    'Смарт-баннеры' AS `Group`
FROM hahn.`//home/antivir/osynskyi/smrt_bnr/smart_with_performance_filter`
GROUP BY week AS Week
UNION ALL
SELECT 
    CAST(SUM_IF(cost, target_type NOT IN (0, 2)) AS Int64) AS Cost,
    Week,
    'Asocial' AS `Group`
FROM hahn.`//home/antivir/osynskyi/ascl/asocial_fnl`
GROUP BY week AS Week
UNION ALL
SELECT 
    SUM(CAST(cost AS Int64)) AS Cost,
    Week,
    'Сексологи / психотерапевты' AS `Group`
FROM hahn.`//home/antivir/osynskyi/sex_psycho`
GROUP BY week AS Week