$week = ($date) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDate(DateTime::StartOfWeek(CAST($date AS Date))))
};

$date = ($x) -> {
    $parse = DateTime::Parse('%Y-%m-%d %H:%M:%S');
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::MakeDatetime($parse($x)))
};

SELECT 
    Week,
    AVG(p120min) AS Avg_p120min,
    AVG(p210min) AS Avg_p210min
FROM (
    SELECT 
        $date(fielddate) AS fielddate,
        p120min / all_clients AS p120min,
        p210min / all_clients AS p210min
    FROM hahn.`home/vipplanners/weekly_pack/moderation_sla`
)
GROUP BY $week(fielddate) AS Week