$week = ($date) -> {
    return DateTime::Format("%Y-%m-%d")(DateTime::StartOfWeek(cast($date as Date)))
};

SELECT 
    week,
    cast(COUNT_IF(rate = 1 or rate = 2) as Double) / count(rate) * 100 as Rate_Share
from (
    SELECT
        log_date,
        if(is_from_uc = 'Со страниц Мастера' AND cast(log_date as Date) < Date('2021-04-28'), NULL, rate) AS rate
    FROM hahn.`home/operanalytics/regular/savakian/feedback/maintab`
    WHERE cast(log_date as Date) > Date('2021-03-15')
)
group by $week(log_date) as week