PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$month = ($dt) -> {
    RETURN DateTime::Format('%Y-%m-%d')(DateTime::StartOfMonth(CAST($dt AS Date)))
};   

SELECT 
    Month,
    Tier_Name,
    SUM(rates_yes) AS rates_yes,
    SUM(rates_no) + SUM(rates_yes) AS Total
FROM hahn.`home/oobp/BA/weekly_pack/cas_tiers_direct_weekly`
GROUP BY
    $month(dt_week) AS Month,
    CASE    
        WHEN client_tier IN ('B2G', 'GT', 'INT LE', 'INT SMB MANAGED', 'INT SMB UNMANAGED', 'International', 'KUB', 'KUB MANAGED', 'KUB UNMANAGED', 'LE', 'NBD', 't1', 't2', 'Tier 0', 'Агентский отдел', 'Агрегатор') THEN 'LE'
        WHEN client_tier IN ('SB', 'SB MANAGED', 't4', 'Самоходное агентство', 'Тир неопределен') THEN 'SB'
        WHEN client_tier IN ('SMB CENTER', 'SMB GEO', 'SMB REGIONS', 't3 Center', 't3 Regions', 'Региональные агентства') THEN 'SMB'
        ELSE NULL
    END AS Tier_Name
