select
    week,
    place,
    device,
    geo,
    sum(ad_hits) as hits,
    sum(shows) as shows,
    sum(clicks) as clicks,
    sum(cost) as cost,
    sum(prgmg) as prgmg,
    sum(installs) as installs
from
    `dwr_new`.`dwr_artmon_log_entry` as data
    left join `dwr_new`.`dwr_pages` as mapping
        on data.page_id = mapping.page_id
where
    month_date >= '2018-01-01' and month_date <= '{to_dt}'
    and place_id IN (542, 1542)
group by
    toMonday(month_date) as week,
    case
        when product_id != 1 and o_and_o_id != 3 then 'Yandex Websites'
        when product_id = 2 and o_and_o_id = 3 then 'Partner Search'
        when product_id = 3 and o_and_o_id = 3 then 'Partner Context'
        when product_id = 1 then 'Yandex Search'
        else toString(product_id)
    end as place,
    if(device_id <= 2, 'Mobile', 'Desktop') as device,
    case
        when regionIn(toUInt32(region_id), toUInt32(1)) then 'Moscow'
        when regionIn(toUInt32(region_id), toUInt32(10174)) then 'Saint-Petersburg'
        when regionIn(toUInt32(region_id), toUInt32(225)) then 'Regions'
        else 'World'
    end as geo;
