$week = ($date) -> {
    RETURN DateTime::MakeDate(DateTime::StartOfWeek(CAST($date AS Date)))
};

use hahn;
SELECT
  Week,
  place,
  sum(t1.cost_noncommerce) AS cost_noncommerce,
  sum(t1.cost_commerce) AS cost_commerce
  FROM `//home/comdep-analytics/dashboards/noncommerce/effect_stats_by_slice` AS t1
  --t1.place_id = 542
  GROUP BY $week(t1.dt) as Week,
  case when `ownership`='internal' and `page_type`='search' then 'Поиск'
  when  `ownership`='external' then 'Внешняя сеть'
  else 'Внутреняя сеть'
  end   as place
