use hahn;
PRAGMA dq.AnalyzeQuery = "1";
$cost_table = "home/vipplanners/users/i-anokhin/weekly_pack/costs";
$survival_rate_table = "home/vipplanners/users/i-anokhin/weekly_pack/survival_rate";
$promocode_activation_table = "home/vipplanners/users/i-anokhin/weekly_pack/promocode_activation";
$desktop_campaign_only_table = "home/vipplanners/users/i-anokhin/weekly_pack/desktop_campaign_only";

select
    t1.week as week,
    agencies_cost,
    prev_agencies_cost,
    cost,
    prev_cost,
    media_revenue,
    prev_media_revenue,
    apps_clients,
    prev_apps_clients,
    apps_cost,
    prev_apps_cost,
    inapp_revenue,
    prev_inapp_revenue,
    p_95_desktop,
    p_95_mobile,
    money_first_2_month,
    cid_create,
    count_activation_partners,
    count_activation_landings,

    search_conversion_strat_share,
    network_conversion_strat_share,
    total_conversion_strat_share,
    smart_share,
    retargeting_share,
    total_auto_strategy_share,
    search_auto_strategy_share,
    rsya_auto_strategy_share

from $cost_table as t1
    left join $survival_rate_table as t2 on t1.week = t2.week
    left join $promocode_activation_table as t3 on t1.week = t3.week

order by week asc
