use hahn;
PRAGMA dq.AnalyzeQuery = "1";
$rpm = '//home/vipplanners/users/i-anokhin/weekly_pack/rmp_installs';
$week = ($date) -> {
    return DateTime::Format('%Y-%m-%d')(Datetime::MakeDate(DateTime::StartOfWeek(cast($date as Date))))
};

select
    week,
    sum(count_installs) as installs_total,
    sum_if(count_installs, rsyQualifier = 'serp') as installs_search,
    sum_if(count_installs, rsyQualifier != 'serp') as installs_network,
    sum_if(count_installs, YappQualifier = 'Yapp') as installs_yapp,
    sum_if(count_installs, YappQualifier != 'Yapp') as installs_not_yapp,
    sum_if(count_installs, gameQualifier = 'game') as installs_game
from $rpm
group by $week(day) as week
