#!/usr/bin/env python3
# -*- coding: utf-8 -*-
from setuptools import setup, find_packages


if __name__ == '__main__':
    setup(
        name='weekly_pack',
        version='0.1.1',
        packages=find_packages(),
        include_package_data=True,
        package_data={
            'weekly_pack': ['logger.yml', 'data/queries/*.sql', 'data/*.yml', 'templates/*.xlsx'],
        },
        install_requires=[
            'docopt>=0.6',
            'pandas==0.19.0',
            'numpy<1.17.0',
            'PyYAML',
            'python-statface-client==0.150.0',
            'yandex-yt==0.9.9',
            'yandex-yt-yson-bindings==0.3.31.post0',
            'yql==1.2.86'
        ],
        dependency_links=[
            'https://pypi.yandex-team.ru/simple/'
        ],
        entry_points={
            'console_scripts': [
                'weekly-pack = weekly_pack.cli: main'
            ]
        }
    )
