# -*- coding: utf-8 -*-
"""
Usage:client_analytics.weekly_pack_py3.
    weekly-pack <artmon_token> <token>

Options:
    -h --help     Show this screen.
"""
from docopt import docopt
import logging
from logging.config import dictConfig
import yaml
import warnings
from client_analytics.weekly_pack_py3.weekly_pack.utils import get_file
from client_analytics.weekly_pack_py3.weekly_pack.data.make_xlsx import run_data_workers
warnings.filterwarnings('ignore')

with get_file('logger.yml') as fd:
    dictConfig(yaml.load(fd))

logger = logging.getLogger(__name__)


def main():
    args = docopt(__doc__)
    with open(u'user_secret.yml', 'w') as fd:
        yaml.dump({'artmon_token': args['<artmon_token>'], 'token': args['<token>']}, fd)
    run_data_workers()


if __name__ == '__main__':
    main()
