use hahn;

$geo = ($region_id, $group_id) -> {
    return Geo::IsRegionInRegion($region_id, $group_id)
};

$week = ($date) -> {
    return DateTime::Format("%Y-%m-%d")(DateTime::StartOfWeek(cast($date as Date)))
};

SELECT 
    Start_of_week,
    Week_num,
    Year,
    SUM_IF(costs, $geo(region_id, 225)) as Russia_Cost,
    SUM_IF(costs, $geo(region_id, 166)) as CIS_Cost,
    SUM_IF(costs, not $geo(region_id, 225) and not $geo(region_id, 166)) as Other_Cost
from `home/vipplanners/weekly_pack/region_costs`
where place = 'network'
GROUP BY 
$week(day) as Start_of_week,
    DateTime::GetWeekOfYear(CAST ($week(day)  as Date)) as Week_num,
    DateTime::GetYear(CAST($week(day)  as Date)) as Year