SELECT 
    Week,
    SUM_IF(cube_revenue_w_cpa, commerce_type = 'commerce') AS Revenue,
    Place
FROM hahn.`home/mcsanalytics/kalamkas/yan_cube_shortened_v1`
WHERE fraud_type = 'normal'
GROUP BY
    Week,
    IF(network_type = 'yan',
        CASE
            WHEN ownership_type = 'internal' AND segment = 'Я.Дзен' THEN 'Дзен'
            WHEN ownership_type = 'internal' AND segment <> 'Я.Дзен' THEN 'Внутренняя сеть без Дзена'
            WHEN ownership_type = 'external' AND (segment = 'sdk' or segment = 'ssp') THEN 'InApp'
            WHEN ownership_type = 'external' AND NOT (segment = 'sdk' or segment = 'ssp') THEN 'Внешняя сеть без InApp'
            ELSE NULL
        END,
        CASE
            WHEN device_type <=4 THEN 'Поиск Мобильные'
            ELSE 'Поиск Десктоп'
        END) AS Place