$t = (
SELECT 
    period,
    CASE 
        WHEN money IS NOT NULL AND reporting_tier = 'SMB CENTER' THEN counterparty_id
        ELSE NULL 
    END AS SMB_Center,
    CASE 
        WHEN money IS NOT NULL AND reporting_tier = 'SMB REGIONS' THEN counterparty_id
        ELSE NULL 
    END AS SMB_Regions,
    CASE 
        WHEN money IS NOT NULL AND (reporting_tier = 'SB MANAGED' OR crm_tier = 'SB MANAGED') AND sales_manager_login != 'none' THEN counterparty_id
        ELSE NULL 
    END AS SB_Managed,
    CASE 
        WHEN money IS NOT NULL AND COALESCE(crm_tier, reporting_tier) = 'SMB GEO' THEN counterparty_id 
        ELSE NULL 
    END AS SMB_Geo,
    CASE 
        WHEN money IS NOT NULL AND servicing IN ('elama', 'agency') AND (COALESCE(crm_tier, reporting_tier) IN ('SB', 'SB MANAGED') AND sales_manager_login = 'none') AND IF(reporting_tier IN ('SMB REGIONS', 'SB') AND rus_macroregion_name IN ('Урал', 'Поволжье', 'Сибирь/ДВ', 'Юг') OR agency_tier = 'Региональные агентства', 1, 0) = 0 THEN counterparty_id 
        ELSE NULL 
    END AS Col1, 
    CASE 
        WHEN money IS NOT NULL AND servicing IN ('elama', 'agency') AND (COALESCE(crm_tier, reporting_tier) IN ('SB', 'SB MANAGED') AND sales_manager_login = 'none') AND IF(reporting_tier IN ('SMB REGIONS', 'SB') AND rus_macroregion_name IN ('Урал', 'Поволжье', 'Сибирь/ДВ', 'Юг') OR IF(agency_tier = 'Региональные агентства', 1, 0) = 1, 1, 0) != 0 THEN counterparty_id
        ELSE NULL 
    END AS Col2,
    CASE
        WHEN money IS NOT NULL AND servicing IN ('elama', 'agency') AND (reporting_tier IN ('SB', 'SB MANAGED') AND sales_manager_login = 'none' OR crm_tier = 'SB MANAGED') THEN counterparty_id
        ELSE NULL
    END AS Col3,
    CASE
        WHEN money IS NOT NULL AND reporting_tier = 'SMB CENTER' THEN counterparty_id
        ELSE NULL
    END AS Col4,
    CASE
        WHEN money IS NOT NULL AND reporting_tier = 'SMB REGIONS' THEN counterparty_id
        ELSE NULL
    END AS Col5,
    CASE
        WHEN money IS NOT NULL AND (reporting_tier = 'SB MANAGED' OR crm_tier = 'SB MANAGED') AND sales_manager_login != 'none' THEN counterparty_id
        ELSE NULL
    END AS Col6,
    CASE
        WHEN money IS NOT NULL AND COALESCE(crm_tier, reporting_tier) = 'SMB GEO' THEN counterparty_id
        ELSE NULL
    END AS Col7,
    IF(money_segment_3m = '150k', '150k+', money_segment_3m) AS Money_Segment
FROM hahn.`//home/comdep-dwh/reporting/datasets/dash/tiers_by_cp_alt`
WHERE 1 = 1
AND currency IN ('rur', 'rur') 
AND slice IN ('База закрытия')
AND money_and_forec IS NOT NULL 
AND CAST(period AS Date) >= Date('2021-01-01')
AND IF(COALESCE(excluded_revenue, 'false') = 'false', 0, 1) IN (0)
AND scale IN ('months', 'months')
AND type_slice IN ('clients', 'clients')
AND product IN ('Общая выручка', 'Общая выручка')
);

SELECT 
period,
Money_Segment,
CAST((Count(DISTINCT SMB_Center) + Count(DISTINCT SMB_Regions) + Count(DISTINCT SB_Managed) + Count(DISTINCT SMB_Geo)) AS Double) / (Count(DISTINCT Col1) + Count(DISTINCT Col2) + Count(DISTINCT Col3) + Count(DISTINCT Col4) + Count(DISTINCT Col5) + Count(DISTINCT Col6) + Count(DISTINCT Col7)) AS Share
from $t
group by period, Money_Segment
ORDER BY period DESC