$week = ($day) -> {
    return DateTime::Format("%Y-%m-%d")(DateTime::StartOfWeek(cast($day as Date)))
};

SELECT 
    Week,
    MEDIAN(first_click_time_h) AS First_click_time,
    App_type
FROM vanga.`//home/operanalytics/dashboards/time_to_target/final_`
WHERE 1 = 1
AND IF(app_type = 'Мастер кампаний' AND CAST(create_day AS Date) < Date('2021-03-08'), 0, 1) = 1
AND has_start_time IN ('Без отложенного старта')
AND is_fraud IN ('Не Фрод')
AND client_tier IN ('SB', 'SMB CENTER', 'SMB REGIONS')
GROUP BY
    $week(create_day) AS Week,
    IF(app_type = 'Мастер кампаний', 'UC', 'Все, кроме UC') AS App_type
ORDER BY Week DESC





