use mtch;

select
    clientStartWeek as week,
    NEWLOGIN as login_created,
    COUNTRY_AND_CURRENCY_SELECTED / NEWLOGIN as "сhose_country",
    CAMPAIGN_TO_CREATE_CLICKED / NEWLOGIN as "сhose_campaign_type",
    CREATE_CAMPAIGN_CLICKED_NEXT / NEWLOGIN as "first_step_campaign_creation",
    CREATE_GROUP_CLICKED_NEXT / NEWLOGIN as "second_step_campaign_creation",
    CREATE_BANNER_CLICKED_NEXT / NEWLOGIN as "third_step_campaign_creation",
    SEND_TO_MODERATION_CLICKED / NEWLOGIN as "sent_to_moderation",
    PAY_PROF / NEWLOGIN as "pay_proff"
from
    (
        select
            clientStartWeek,
            sum(if(Goal like '%NEWLOGIN', cnt_users, 0)) as NEWLOGIN,
            sum(if(Goal like '%COUNTRY_AND_CURRENCY_SELECTED', cnt_users, 0)) as COUNTRY_AND_CURRENCY_SELECTED,
            sum(if(Goal like '%CAMPAIGN_TO_CREATE_CLICKED', cnt_users, 0)) as CAMPAIGN_TO_CREATE_CLICKED,
            sum(if(Goal like '%SET_EMAIL', cnt_users, 0)) as SET_EMAIL,
            sum(if(Goal like '%CREATE_CAMPAIGN_CLICKED_NEXT', cnt_users, 0)) as CREATE_CAMPAIGN_CLICKED_NEXT,
            sum(if(Goal like '%CREATE_GROUP_CLICKED_NEXT', cnt_users, 0)) as CREATE_GROUP_CLICKED_NEXT,
            sum(if(Goal like '%START_ADVERT', cnt_users, 0)) as START_ADVERT,
            sum(if(Goal like '%CREATE_BANNER_CLICKED_NEXT', cnt_users, 0)) as CREATE_BANNER_CLICKED_NEXT,
            sum(if(Goal like '%SEND_TO_MODERATION_CLICKED', cnt_users, 0)) as SEND_TO_MODERATION_CLICKED,
            sum(if(Goal like '%DIRECT-MODERATION', cnt_users, 0)) as DIRECT_MODERATION,
            sum(if(Goal like '%PAY-PROF', cnt_users, 0)) as PAY_PROF
        from
            (
                select
                    Goal,
                    clientStartWeek,
                    count(distinct PassportUserID) as cnt_users
                from
                    (
                        select
                            PassportUserID,
                            EventDate,
                            replace(URL, '_DNA', '') as Goal
                        from hits_all
                        where
                            (EventDate >= toDate('2020-01-20'))
                            and (CounterID == 191494)
                            and (URL like 'goal://direct.yandex.ru/%')
                            and not IsRobot
                    ) as all_sessions inner join
                        (
                            select
                                replace(URL, '_DNA', '') as firstGoal,
                                min(toStartOfMonth(EventDate)) as clientStartWeek,
                                min(EventDate) as clientStartDate,
                                PassportUserID
                            from hits_all
                            where
                                (EventDate >= toDate('2020-01-20'))
                                and (EventDate < addWeeks(toStartOfWeek(today()), -3))
                                and (CounterID == 191494)
                                and not IsRobot
                                and (firstGoal like 'goal://direct.yandex.ru/NEWLOGIN')
                            group by PassportUserID, firstGoal
                        ) as new_users on all_sessions.PassportUserID = new_users.PassportUserID
                where (EventDate >= clientStartDate) and (EventDate < addWeeks(clientStartDate, 3))
                group by Goal, clientStartWeek
            )
        group by clientStartWeek
        order by clientStartWeek
    )
