use markov;

$day_from_seconds = ($update_time) -> {
    $format = DateTime::Format('%Y-%m-%d');
    return $format(AddTimezone(cast($update_time as Datetime), 'Europe/Moscow'))
};

select
    day,
    check_name,
    percentile(runtime, 0.95) as runtime,
    from (
            select
                $day_from_seconds(StartTime) as day,
                CheckName as check_name,
                FinishTime - StartTime as runtime
            from `//home/yabs/overmind/direct_monitoring/prod/ArchiveChecks`
            where
                IsDeadHost = False
                and $day_from_seconds(StartTime) >= '2020-01-01'
        )
group by
    day,
    case check_name
        when 'AddNewBannerCheck' then 'Новый баннер'
        when 'ChangeBannerTextCheck' then 'Изменение баннера'
        when 'ChangePhrasePriceCheck' then 'Изменение ставки'
        when 'ChangePhraseTextCheck' then 'Изменение текста'
        when 'ResumeBannerCheck' then 'Запуск баннера'
        when 'ResumeCampaignCheck' then 'Запуск кампании'
        when 'SuspendBannerCheck' then 'Остановка баннера'
        when 'SuspendCampaignCheck' then 'Остановка кампании'
        else check_name
    end as check_name
order by day, check_name asc;
