use hahn;
pragma yt.InferSchema = '1';

$parse = DateTime::Parse('%Y-%m-%d');
$format = DateTime::Format('%Y-%m-%d');
$forecast_path = '{forecast_path}';
$monthly_forecast_path = '{monthly_forecast_path}';


$forecast = 
    select 
        `date`,
        'forecast' as type,
        sum(search) as search,
        sum(internal_inc_ps) as internal_inc_ps,
        sum(external_wo_ps) as external_wo_ps,
        sum(external_ps) as external_ps,
        sum(display) as display,
        sum(cpm_video) as cpm_video,
        sum(cpc_video) as cpc_video
    from $forecast_path
    where `date` >= '2020-01-01'
    group by
        $format(DateTime::StartOfMonth($parse(`date`))) as `date`;


$k1 = 
    select 
        forecast.`date` as `date`,
        'k1' as type,
        forecast.search * k1.search as search,
        forecast.internal_inc_ps * k1.internal_inc_ps as internal_inc_ps,
        forecast.external_wo_ps * k1.external_wo_ps as external_wo_ps,
        forecast.external_ps * k1.external_ps as external_ps,
        forecast.display * k1.display as display,
        forecast.cpm_video * k1.cpm_video as cpm_video,
        forecast.cpc_video * k1.cpc_video as cpc_video
    from $forecast as forecast
    left join `//home/vipplanners/weekly_update/manual_data/k1` as k1
        on forecast.`date` = k1.`date`;

$k2 = 
    select
        k1.`date` as `date`,
        'cost' as type,
        k1.search + k2.search as search,
        k1.internal_inc_ps + k2.internal_inc_ps as internal_inc_ps,
        k1.external_wo_ps + k2.external_wo_ps as external_wo_ps,
        k1.external_ps + k2.external_ps as external_ps,
        k1.display + k2.display as display,
        k1.cpm_video + k2.cpm_video as cpm_video,
        k1.cpc_video + k2.cpc_video as cpc_video
    from $k1 as k1
    left join `//home/vipplanners/weekly_update/manual_data/k2` as k2
        on k1.`date` = k2.`date`;

$gross = 
    select 
        cost.`date` as `date`,
        'gross_fd' as type,
        cost.search * gross.search AS search,
        cost.internal_inc_ps * gross.internal_inc_ps as internal_inc_ps,
        cost.external_wo_ps * gross.external_wo_ps as external_wo_ps,
        cost.external_ps * gross.external_ps as external_ps,
        cost.display * gross.display as display,
        cost.cpm_video * gross.cpm_video as cpm_video,
        cost.cpc_video * gross.cpc_video as cpc_video
    from $k2 as cost
    left join `//home/vipplanners/weekly_update/manual_data/gross` as gross
        on cost.`date` = gross.`date`;


$net = 
    select
        gross.`date` as `date`,
        'net' as type,
        gross.search - rewards.direct * (gross.search / gross.direct) as search,
        gross.internal_inc_ps - rewards.direct * (gross.internal_inc_ps / gross.direct) as internal_inc_ps,
        gross.external_wo_ps - rewards.direct * (gross.external_wo_ps / gross.direct) as external_wo_ps,
        gross.external_ps - rewards.direct * (gross.external_ps / gross.direct) as external_ps,
        gross.cpc_video - rewards.direct * (gross.cpc_video / gross.direct) as cpc_video,
        gross.display - rewards.display * (gross.display / gross.cpm_total) as display,
        gross.cpm_video - rewards.display * (gross.cpm_video / gross.cpm_total) as cpm_video
    from 
        (select 
            `date`,
            (search + internal_inc_ps + external_wo_ps + external_ps) as direct,
            search,
            internal_inc_ps,
            external_wo_ps,
            external_ps,
            (display + cpm_video) as cpm_total,
            display,
            cpm_video,
            cpc_video
        from $gross) as gross
    left join `//home/vipplanners/weekly_update/manual_data/rewards` as rewards
        on gross.`date` = rewards.`date`;


insert into $monthly_forecast_path with truncate
select 
    `date`,
    type,
    search,
    internal_inc_ps,
    external_wo_ps,
    external_ps,
    (display + cpm_video) as cpm_total,
    display,
    cpm_video,
    cpc_video
from (
    select * from $forecast
    union all
    select * from $k1
    union all
    select * from $k2
    union all
    select * from $gross
    union all
    select * from $net
)