PRAGMA yt.PoolTrees             = "physical";
PRAGMA yt.TentativePoolTrees    = "cloud";
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$date_start = CAST(CurrentUtcDate() - DateTime::IntervalFromDays(14) AS String);
$date_end   = CAST(CurrentUtcDate() AS String);

$parse_v_row = ($r) -> {
    RETURN AsList(
        AsStruct(
            'Авто.ру'                       AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.autoru_hits                  AS hits,
            $r.autoru_timespent             AS timespent,
            $r.autoru_users                 AS users,
            $r.autoru_visits                AS visits
        ),
        AsStruct(
            'Я.Коллекции'                   AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.collections_hits             AS hits,
            $r.collections_timespent        AS timespent,
            $r.collections_users            AS users,
            $r.collections_visits           AS visits
        ),
        AsStruct(
            'Я.Диск'                        AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.disk_hits                    AS hits,
            $r.disk_timespent               AS timespent,
            $r.disk_users                   AS users,
            $r.disk_visits                  AS visits
        ),
        AsStruct(
            'Едадил'                        AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.edadeal_hits                 AS hits,
            $r.edadeal_timespent            AS timespent,
            $r.edadeal_users                AS users,
            $r.edadeal_visits               AS visits
        ),
        AsStruct(
            'Я.Здоровье'                    AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.health_hits                  AS hits,
            $r.health_timespent             AS timespent,
            $r.health_users                 AS users,
            $r.health_visits                AS visits
        ),
        AsStruct(
            'Я.Картинки'                    AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.images_hits                  AS hits,
            $r.images_timespent             AS timespent,
            $r.images_users                 AS users,
            $r.images_visits                AS visits
        ),
        AsStruct(
            'Я.Почта'                       AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.mail_hits                    AS hits,
            $r.mail_timespent               AS timespent,
            $r.mail_users                   AS users,
            $r.mail_visits                  AS visits
        ),
        AsStruct(
            'Я.Морда'                       AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.morda_hits                   AS hits,
            $r.morda_timespent              AS timespent,
            $r.morda_users                  AS users,
            $r.morda_visits                 AS visits
        ),
        AsStruct(
            'Я.Новости'                     AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.news_hits                    AS hits,
            $r.news_timespent               AS timespent,
            $r.news_users                   AS users,
            $r.news_visits                  AS visits
        ),
        AsStruct(
            'Я.Погода'                      AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.pogoda_hits                  AS hits,
            $r.pogoda_timespent             AS timespent,
            $r.pogoda_users                 AS users,
            $r.pogoda_visits                AS visits
        ),
        AsStruct(
            'Я.Расписания'                  AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.rasp_hits                    AS hits,
            $r.rasp_timespent               AS timespent,
            $r.rasp_users                   AS users,
            $r.rasp_visits                  AS visits
        ),
        AsStruct(
            'Я.Спорт'                       AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.sport_hits                   AS hits,
            $r.sport_timespent              AS timespent,
            $r.sport_users                  AS users,
            $r.sport_visits                 AS visits
        ),
        AsStruct(
            'TheQuestion.ru'                AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.thequestion_hits             AS hits,
            $r.thequestion_timespent        AS timespent,
            $r.thequestion_users            AS users,
            $r.thequestion_visits           AS visits
        ),
        AsStruct(
            'Я.Видео'                       AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.video_hits                   AS hits,
            $r.video_timespent              AS timespent,
            $r.video_users                  AS users,
            $r.video_visits                 AS visits
        ),
        AsStruct(
            'Я.Знатоки'                     AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.znatoki_hits                 AS hits,
            $r.znatoki_timespent            AS timespent,
            $r.znatoki_users                AS users,
            $r.znatoki_visits               AS visits
        ),
        AsStruct(
            'Я.Q'                           AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.qiu_hits                     AS hits,
            $r.qiu_timespent                AS timespent,
            $r.qiu_users                    AS users,
            $r.qiu_visits                   AS visits
        ),
        AsStruct(
            'Я.Афиша'                       AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.afisha_hits                  AS hits,
            $r.afisha_timespent             AS timespent,
            $r.afisha_users                 AS users,
            $r.afisha_visits                AS visits
        ),
        AsStruct(
            'Я.Услуги'                      AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.uslugi_hits                  AS hits,
            $r.uslugi_timespent             AS timespent,
            $r.uslugi_users                 AS users,
            $r.uslugi_visits                AS visits
        ),
        AsStruct(
            'Я.Телепрограмма'               AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.tv_hits                      AS hits,
            $r.tv_timespent                 AS timespent,
            $r.tv_users                     AS users,
            $r.tv_visits                    AS visits
        ),
        AsStruct(
            'Я.Недвижимость'                AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.realty_hits                  AS hits,
            $r.realty_timespent             AS timespent,
            $r.realty_users                 AS users,
            $r.realty_visits                AS visits
        ),
        AsStruct(
            'Я.Путешествия'                 AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.travel_hits                  AS hits,
            $r.travel_timespent             AS timespent,
            $r.travel_users                 AS users,
            $r.travel_visits                AS visits
        ),
        AsStruct(
            'Я.Эфир'                        AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.stream_hits                  AS hits,
            $r.stream_timespent             AS timespent,
            $r.stream_users                 AS users,
            $r.stream_visits                AS visits
        ),
        AsStruct(
            'Я.Игры'                        AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.games_hits                   AS hits,
            $r.games_timespent              AS timespent,
            $r.games_users                  AS users,
            $r.games_visits                 AS visits
        ),
        AsStruct(
            'Я.Работа'                      AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.rabota_hits                  AS hits,
            $r.rabota_timespent             AS timespent,
            $r.rabota_users                 AS users,
            $r.rabota_visits                AS visits
        ),
        AsStruct(
            'Кинопоиск'                     AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.kinopoisk_hits               AS hits,
            $r.kinopoisk_timespent          AS timespent,
            $r.kinopoisk_users              AS users,
            $r.kinopoisk_visits             AS visits
        ),
        AsStruct(
            'Я.Авиа'                        AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.avia_hits                    AS hits,
            $r.avia_timespent               AS timespent,
            $r.avia_users                   AS users,
            $r.avia_visits                  AS visits
        ),
        AsStruct(
            'Я.Объявления'                        AS segment,
            $r.metrika_devicetype           AS metrika_devicetype,
            $r.classifieds_hits                    AS hits,
            $r.classifieds_timespent               AS timespent,
            $r.classifieds_users                   AS users,
            $r.classifieds_visits                  AS visits
        )
    )
};

$v = (
    SELECT
        report_date,
        arpu_segment,
        internal_platform_type,
        CAST(SUM(hits) AS Int64)        AS hits,
        CAST(SUM(timespent) AS Double)  AS timespent,
        CAST(SUM(users) AS Int64)       AS users,
        CAST(SUM(visits) AS Int64)      AS visits
    FROM (
        SELECT *
        FROM (
            SELECT
                day,
                parsed_row
            FROM (
                SELECT
                    day,
                    $parse_v_row(TableRow()) AS parsed_row
                FROM
                    RANGE(`//home/meteo/bushivan/imicroab/peruser_metrics/v`, $date_start, $date_end)
                ) FLATTEN LIST BY parsed_row
            ) FLATTEN COLUMNS
        )
    WHERE
        -- чистим данные от выбросов
        NOT (segment == 'Я.Здоровье' AND CAST(day AS String) <= '2018-11-28') AND
        NOT (segment == 'Я.Эфир'     AND CAST(day AS String) <= '2019-11-22')
    GROUP BY
        CAST(day AS String)                                     AS report_date,
        segment                                                 AS arpu_segment,
        IF(metrika_devicetype == 'touch', 'mobile', 'desktop')  AS internal_platform_type
);

$parse_m_row = ($r) -> {
    RETURN AsList(
        AsStruct(
            'Я.Авиа'                    AS segment,
            $r.AppPlatform              AS app_platform,
            $r.avia_devices             AS users
        ),
        AsStruct(
            'Я.Диск'                    AS segment,
            $r.AppPlatform              AS app_platform,
            $r.disk_devices             AS users
        ),
        AsStruct(
            'Едадил'                    AS segment,
            $r.AppPlatform              AS app_platform,
            $r.edadeal_devices          AS users
        ),
        AsStruct(
            'Я.Почта'                   AS segment,
            $r.AppPlatform              AS app_platform,
            $r.mail_devices             AS users
        ),
        AsStruct(
            'Я.Карты'                   AS segment,
            $r.AppPlatform              AS app_platform,
            $r.maps_devices             AS users
        ),
        AsStruct(
            'Я.Метро'                   AS segment,
            $r.AppPlatform              AS app_platform,
            $r.metro_devices            AS users
        ),
        AsStruct(
            'Я.Навигатор'               AS segment,
            $r.AppPlatform              AS app_platform,
            $r.navigator_devices        AS users
        ),
        AsStruct(
            'Я.Погода'                  AS segment,
            $r.AppPlatform              AS app_platform,
            $r.pogoda_devices           AS users
        ),
        AsStruct(
            'ПП'                      AS segment,
            $r.AppPlatform              AS app_platform,
            $r.searchapp_devices        AS users
        ),
        AsStruct(
            'Я.Транспорт'               AS segment,
            $r.AppPlatform              AS app_platform,
            $r.transport_devices        AS users
        ),
        AsStruct(
            'Я.Транспорт'               AS segment,
            $r.AppPlatform              AS app_platform,
            $r.transport_devices        AS users
        )
    )
};

$m = (
    SELECT
        report_date,
        arpu_segment,
        internal_platform_type,
        null                        AS hits,
        null                        AS timespent,
        CAST(SUM(users) AS Int64)   AS users,
        null                        AS visits
    FROM (
        SELECT *
        FROM (
            SELECT
                day,
                parsed_row
            FROM (
                SELECT
                    day,
                    $parse_m_row(TableRow()) AS parsed_row
                FROM
                    `//home/mstand/bushivan/apps_summary`
                WHERE
                    CAST(day AS String) BETWEEN $date_start AND $date_end
                ) FLATTEN LIST BY parsed_row
            ) FLATTEN COLUMNS
        )
    GROUP BY
        CAST(day AS String)                         AS report_date,
        segment                                     AS arpu_segment,
        if(app_platform == 'iOS', 'ios', 'android') AS internal_platform_type
);

$traffic = (
    SELECT * FROM $v
    UNION ALL
    SELECT * FROM $m
);

$get_internal_platform_type = ($r) -> {
    RETURN CASE
    WHEN $r.ownership_type == 'internal' and
        $r.traffic_type == 'sdk'
        THEN $r.traffic_os
    WHEN $r.ownership_type == 'internal' and
        $r.traffic_subtype == 'turbo-desktop'
        THEN 'desktop'
    WHEN $r.ownership_type == 'internal' and
        $r.traffic_subtype == 'turbo-mobile'
        THEN 'mobile'
    WHEN $r.ownership_type == 'internal'
        THEN $r.traffic_platform
    ELSE NULL
    END
};

$services_with_traffic = (
    'Авто.ру',
    'Я.Коллекции',
    'Я.Диск',
    'Едадил',
    'Я.Здоровье',
    'Я.Картинки',
    'Я.Почта',
    'Я.Морда',
    'Я.Новости',
    'Я.Погода',
    'Я.Расписания',
    'Я.Спорт',
    'TheQuestion.ru',
    'Я.Видео',
    'Я.Q',
    'Я.Знатоки',
    'Я.Афиша',
    'Я.Услуги',
    'Я.Телепрограмма',
    'Я.Недвижимость',
    'Я.Путешествия',
    'Я.Эфир',
    'Я.Игры',
    'Я.Работа',
    'Кинопоиск',
    'Я.Авиа',
    'ПП',
    'Я.Карты',
    'Я.Метро',
    'Я.Навигатор',
    'Я.Транспорт',
    'Я.Объявления'
);

$get_arpu_subsegment = ($r) -> {
    RETURN CASE
    WHEN $r.internal_service == 'Я.Дзен'                        THEN 'Дзен'
    WHEN $r.internal_service == 'Я.Видеохостинг'                THEN 'Видеохостинг'
    WHEN $r.dsp_type == 'awaps'                                 THEN 'AWAPS'
    WHEN $r.dsp_type == 'direct' and $r.purchase_type == 'cpm'  THEN 'CPM-Директ'
    ELSE 'CPC-Директ'
    END
};

$money = (
    SELECT
        report_date,
        arpu_segment,
        arpu_subsegment,
        internal_platform_type,
        SUM(revenue)            AS revenue,
        SUM(block_shows)        AS block_shows
    FROM `//home/comdep-analytics/YAN/cubes/yan/latest/cooked/latest/compact_cooked_yan_cube` 
    WHERE
        network_type == 'yan' and
        ownership_type == 'internal' and
        report_date BETWEEN $date_start and $date_end and
        internal_service_including_vh_and_zen in $services_with_traffic
    GROUP BY
        report_date,
        internal_service_including_vh_and_zen   AS arpu_segment,
        $get_arpu_subsegment(TableRow())        AS arpu_subsegment,
        $get_internal_platform_type(TableRow()) AS internal_platform_type
    HAVING
        SUM(revenue) > 0
);

$new_data = (
    SELECT
        NVL(m.report_date, t.report_date)                       AS report_date,
        NVL(m.arpu_segment, t.arpu_segment)                     AS arpu_segment,
        m.arpu_subsegment                                       AS arpu_subsegment,
        NVL(m.internal_platform_type, t.internal_platform_type) AS internal_platform_type,
        t.hits                                                  AS hits,
        t.timespent                                             AS timespent,
        t.users                                                 AS users,
        t.visits                                                AS visits,
        m.revenue                                               AS revenue,
        m.block_shows                                           AS block_shows
    FROM $traffic AS t
    FULL JOIN $money AS m
    USING(report_date, arpu_segment, internal_platform_type)
);

$old_data = (
    SELECT *
    FROM `//home/vipplanners/yanpartners/all/arpu_internal/arpu`
    WHERE report_date < $date_start
);

INSERT INTO `//home/vipplanners/yanpartners/all/arpu_internal/arpu` WITH TRUNCATE 
SELECT *
FROM (
    SELECT * FROM $new_data
    UNION ALL
    SELECT * FROM $old_data
    )
ORDER BY
    report_date,
    arpu_segment;


