$commit_start   = '2019-10-01';

$plus_n_days = ($date, $days) -> {
    $lag = CAST($days AS Int16);
    $date = CAST($date AS Date) + DateTime::IntervalFromDays($lag);
    RETURN CAST($date AS String);
};

$minus_n_days = ($date, $days) -> {
    $lag = CAST($days AS Int16);
    $date = CAST($date AS Date) - DateTime::IntervalFromDays($lag);
    RETURN CAST($date AS String);
};

$to_start_month = ($report_date) -> {
    $date = CAST($report_date AS Date);
    RETURN CAST(DateTime::MakeDate(DateTime::StartOfMonth($date)) AS String);
};

$date_start = $minus_n_days($commit_start, 364+28); -- 364 для YoY, 28 чтоб заполнить чарты мин на 28д
$date_end   = CAST(CurrentUtcDate() - DateTime::IntervalFromDays(1) AS String); -- вчера, для дерева

$get_type = ($row) -> {
    RETURN (
        CASE
            WHEN $row.page_type == 'sdk'        THEN 'inapp'
            WHEN $row.adv_subtype == 'inpage'   THEN 'inpage'
            WHEN $row.adv_subtype == 'instream' THEN 'instream'
            ELSE 'rtb'
        END
    );
};

$stats = (
    SELECT
        report_date,
        domain_root,
        device_type,
        SUM(block_shows)                                                AS block_shows,
        SUM_IF(block_shows, $get_type(TableRow()) == 'inapp')           AS block_shows_inapp,
        SUM_IF(block_shows, $get_type(TableRow()) == 'inpage')          AS block_shows_inpage,
        SUM_IF(block_shows, $get_type(TableRow()) == 'instream')        AS block_shows_instream,
        SUM_IF(block_shows, $get_type(TableRow()) == 'rtb')             AS block_shows_rtb,
        SUM(auctions_rtb_all)                                           AS auctions,
        SUM_IF(auctions_rtb_all, $get_type(TableRow()) == 'inapp')      AS auctions_inapp,
        SUM_IF(auctions_rtb_all, $get_type(TableRow()) == 'inpage')     AS auctions_inpage,
        SUM_IF(auctions_rtb_all, $get_type(TableRow()) == 'instream')   AS auctions_instream,
        SUM_IF(auctions_rtb_all, $get_type(TableRow()) == 'rtb')        AS auctions_rtb,
        SUM(tac)                                                        AS tac,
        SUM_IF(tac, $get_type(TableRow()) == 'inapp')                   AS tac_inapp,
        SUM_IF(tac, $get_type(TableRow()) == 'inpage')                  AS tac_inpage,
        SUM_IF(tac, $get_type(TableRow()) == 'instream')                AS tac_instream,
        SUM_IF(tac, $get_type(TableRow()) == 'rtb')                     AS tac_rtb,
        SUM(revenue)                                                    AS revenue,
        SUM_IF(revenue, $get_type(TableRow()) == 'inapp')               AS revenue_inapp,
        SUM_IF(revenue, $get_type(TableRow()) == 'inpage')              AS revenue_inpage,
        SUM_IF(revenue, $get_type(TableRow()) == 'instream')            AS revenue_instream,
        SUM_IF(revenue, $get_type(TableRow()) == 'rtb')                 AS revenue_rtb
    FROM
        `//home/comdep-analytics/YAN/cubes/yan_new/latest/cooked/latest/cooked_yan_cube`
    WHERE
        report_date >= $date_start AND
        ownership_type == 'external' AND
        external_segment == 'tier-1' AND
        publisher_name == 'HSM'
    GROUP BY
        report_date                                             AS report_date,
        NVL(domain_root, 'NULL')                                AS domain_root,
        IF(device_type == 3, 'Mobile', 'Desktop')               AS device_type
);

$get_segment = ($domain_root) -> {
    $FEDERAL = ('elle.ru', 'marieclaire.ru', 'ellegirl.ru',
        'wday.ru', 'woman.ru', 'starhit.ru', 'psychologies.ru',
        'parents.ru', 'maximonline.ru', 'vokrugsveta.ru');
    RETURN
        CASE
            WHEN $domain_root == 'FEDERAL'  THEN 'FEDERAL'
            WHEN $domain_root == 'REGIONAL' THEN 'REGIONAL'
            ELSE IF($domain_root IN $FEDERAL, 'FEDERAL', 'REGIONAL')
        END;
};

$pi_stat = (
    SELECT
        month,
        report_date,
        domain_segment,
        domain_root,
        'Данные ПИ (суммарно)' AS device_type,
        SUM(c.hits) AS pi_hits
    FROM
        `home/comdep-analytics/chaos-ad/pi/v2/ch_stats/statistics` AS c
        INNER JOIN
        `//home/comdep-analytics/YAN/segmentation/latest/segments` AS s
        ON c.page_id == s.page_id
    WHERE
        c.dt >= $date_start AND
        s.partner_login IN ('hsmedia2019', 'lena235', 'e1-ru',
            'herstshkulevmedia', 'khandozhenko-ngs', 'nnov-p', 'officengsnews',
            'officengsru', 'partner-n1-ru', 'rugion-rsya', 'zarplata-partner')
    GROUP BY
        $to_start_month(c.dt)       AS month,
        c.dt                        AS report_date,
        $get_segment(s.domain_root) AS domain_segment,
        s.domain_root               AS domain_root
);

$len = (DateTime::ToDays(Cast($date_end AS Date) - Cast($date_start AS Date)) ?? 0) + 1;
$range_list = ListFromRange(0, $len, 1);
$range_date = ListMap($range_list, ($x) -> { RETURN Cast(Cast($date_start AS Date) + DateTime::IntervalFromDays(Cast($x AS Int16)) AS String); });

$to_start_month = ($report_date) -> {
    $date = CAST($report_date AS Date);
    RETURN CAST(DateTime::MakeDate(DateTime::StartOfMonth($date)) AS String);
};

$tree = (
    SELECT
        $to_start_month(report_date)    AS month,
        report_date                     AS report_date,
        $get_segment(domain_root)       AS domain_segment,
        NVL(domain_root, 'NULL')        AS domain_root,
        device_type                     AS device_type
    FROM (
        SELECT
            $range_date                 AS report_date,
            AsList('Desktop', 'Mobile') AS device_type,
            domain_root
        FROM (
            SELECT DISTINCT
                domain_root
            FROM
                $stats
            UNION ALL
            SELECT 'FEDERAL' AS domain_root
            UNION ALL
            SELECT 'REGIONAL' AS domain_root
            )
        ) AS t FLATTEN BY (report_date, device_type)
);

$fact_daily = (
    SELECT
        report_date,
        domain_segment,
        device_type,
        SUM(revenue)    AS revenue,
        SUM(auctions)   AS auctions
    FROM
        $stats
    GROUP BY
        $plus_n_days(report_date, 364)  AS report_date,
        $get_segment(domain_root)       AS domain_segment,
        device_type
);

$fact_monthly = (
    SELECT
        report_date,
        domain_segment,
        device_type,
        SUM(revenue)    AS revenue,
        SUM(auctions)   AS auctions
    FROM
        $fact_daily
    GROUP BY
        $to_start_month(report_date) AS report_date,
        domain_segment,
        device_type
);

$commit_daily = (
    SELECT
        d.report_date                                           AS report_date,
        -- Для джойна с $tree (см. выше)                        
        d.domain_segment                                        AS domain_root,
        d.device_type                                           AS device_type,
        c.revenue * (d.revenue / m.revenue)                     AS commit_revenue,
        c.auctions * (CAST(d.auctions AS Double) / m.auctions)  AS commit_auctions
    FROM
        `//home/vipplanners/yanpartners/all/YANADHOC-135/commit` AS c
        LEFT JOIN
        $fact_daily AS d
        ON (
            $to_start_month(d.report_date) == c.report_date AND 
            d.domain_segment == c.domain_segment AND
            d.device_type == c.device_type
        )
        LEFT JOIN
        $fact_monthly AS m
        ON (
            $to_start_month(d.report_date) == m.report_date AND 
            d.domain_segment == m.domain_segment AND
            d.device_type == m.device_type
        )
    WHERE
        c.report_date >= $commit_start
);

$plain_report = (
    SELECT
        t.month                 AS month,
        t.report_date           AS report_date,
        t.domain_segment        AS domain_segment,
        t.domain_root           AS domain_root,
        t.device_type           AS device_type,
        s.block_shows           AS block_shows,
        s.block_shows_inapp     AS block_shows_inapp,
        s.block_shows_inpage    AS block_shows_inpage,
        s.block_shows_instream  AS block_shows_instream,
        s.block_shows_rtb       AS block_shows_rtb,
        s.auctions              AS auctions,
        s.auctions_inapp        AS auctions_inapp,
        s.auctions_inpage       AS auctions_inpage,
        s.auctions_instream     AS auctions_instream,
        s.auctions_rtb          AS auctions_rtb,
        s.tac                   AS tac,
        s.tac_inapp             AS tac_inapp,
        s.tac_inpage            AS tac_inpage,
        s.tac_instream          AS tac_instream,
        s.tac_rtb               AS tac_rtb,
        s.revenue               AS revenue,
        s.revenue_inapp         AS revenue_inapp,
        s.revenue_inpage        AS revenue_inpage,
        s.revenue_instream      AS revenue_instream,
        s.revenue_rtb           AS revenue_rtb,
        c.commit_revenue        AS commit_revenue,
        c.commit_auctions       AS commit_auctions
    FROM
        $tree AS t
        LEFT JOIN
        $stats AS s
        ON (
            t.report_date == s.report_date AND
            t.domain_root == s.domain_root AND
            t.device_type == s.device_type
        )
        LEFT JOIN
        $commit_daily AS c
        ON (
            t.report_date == c.report_date AND
            t.domain_root == c.domain_root AND
            t.device_type == c.device_type
        )
        
);

$dataset = (
    SELECT
        month,
        report_date                         AS report_date,
        domain_segment                      AS domain_segment,
        domain_root                         AS domain_root,
        device_type                         AS device_type,
        block_shows                         AS block_shows,
        block_shows_inapp                   AS block_shows_inapp,
        block_shows_inpage                  AS block_shows_inpage,
        block_shows_instream                AS block_shows_instream,
        block_shows_rtb                     AS block_shows_rtb,
        auctions                            AS auctions,
        auctions_inapp                      AS auctions_inapp,
        auctions_inpage                     AS auctions_inpage,
        auctions_instream                   AS auctions_instream,
        auctions_rtb                        AS auctions_rtb,
        tac                                 AS tac,
        tac_inapp                           AS tac_inapp,
        tac_inpage                          AS tac_inpage,
        tac_instream                        AS tac_instream,
        tac_rtb                             AS tac_rtb,
        revenue                             AS revenue,
        revenue_inapp                       AS revenue_inapp,
        revenue_inpage                      AS revenue_inpage,
        revenue_instream                    AS revenue_instream,
        revenue_rtb                         AS revenue_rtb,
        pi_hits                             AS pi_hits,
        commit_revenue                      AS commit_revenue,
        commit_auctions                     AS commit_auctions,
        LAG(block_shows,        7) OVER w   AS lag7_block_shows,
        LAG(auctions,           7) OVER w   AS lag7_auctions,
        LAG(tac,                7) OVER w   AS lag7_tac,
        LAG(revenue,            7) OVER w   AS lag7_revenue,
        LAG(block_shows,      364) OVER w   AS lag364_block_shows,
        LAG(auctions,         364) OVER w   AS lag364_auctions,
        LAG(tac,              364) OVER w   AS lag364_tac,
        LAG(revenue,          364) OVER w   AS lag364_revenue
    FROM
        (
        SELECT * FROM $plain_report
        UNION ALL
        SELECT * FROM $pi_stat
        )
    WINDOW w AS (
        PARTITION BY
            domain_segment,
            domain_root,
            device_type
        ORDER BY
            report_date
    )
);

INSERT INTO `//home/vipplanners/yanpartners/all/hsm/main_dataset_2` WITH TRUNCATE
SELECT
    month,
    report_date,
    domain_segment,
    device_type,
    domain_root,
    block_shows,
    block_shows_inapp,
    block_shows_inpage,
    block_shows_instream,
    block_shows_rtb,
    auctions,
    auctions_inapp,
    auctions_inpage,
    auctions_instream,
    auctions_rtb,
    tac,
    tac_inapp,
    tac_inpage,
    tac_instream,
    tac_rtb,
    revenue,
    revenue_inapp,
    revenue_inpage,
    revenue_instream,
    revenue_rtb,
    pi_hits,
    lag7_block_shows,
    lag7_auctions,
    lag7_tac,
    lag7_revenue,
    lag364_block_shows,
    lag364_auctions,
    lag364_tac,
    lag364_revenue,
    commit_revenue,
    commit_auctions,
    SUM(commit_revenue)  OVER w   AS commit_revenue_cumulative,
    SUM(commit_auctions) OVER w   AS commit_auctions_cumulative,
    SUM(revenue)         OVER w   AS revenue_cumulative,
    SUM(tac)             OVER w   AS tac_cumulative,
    SUM(auctions)        OVER w   AS auctions_cumulative,
    SUM(pi_hits)         OVER w   AS pi_hits_cumulative,
    SUM(commit_revenue)  OVER e   AS commit_revenue_cumulative_all,
    SUM(commit_auctions) OVER e   AS commit_auctions_cumulative_all,
    SUM(revenue)         OVER e   AS revenue_cumulative_all,
    SUM(tac)             OVER e   AS tac_cumulative_all,
    SUM(auctions)        OVER e   AS auctions_cumulative_all,
    SUM(pi_hits)         OVER e   AS pi_hits_cumulative_all,
FROM
    $dataset
WHERE
    report_date >= $commit_start
WINDOW w AS (
    PARTITION BY
        month,
        domain_segment,
        domain_root,
        device_type
    ORDER BY
        report_date
),
    e AS (
    PARTITION BY
        domain_segment,
        domain_root,
        device_type
    ORDER BY
        report_date
)
ORDER BY
    report_date,
    domain_root,
    device_type;

$federal_domanis = (
    'elle.ru',
    'marieclaire.ru',
    'ellegirl.ru',
    'wday.ru',
    'woman.ru',
    'starhit.ru',
    'psychologies.ru',
    'parents.ru',
    'maximonline.ru',
    'vokrugsveta.ru',
    'elledecoration.ru'
);

$regional_domains = (
    'e1.ru',
    'ngs.ru',
    'ngs24.ru',
    'ngs55.ru',
    'ngs22.ru',
    'ngs70.ru',
    'ngs38.ru',
    'nn.ru',
    '74.ru',
    '72.ru',
    '63.ru',
    'ufa1.ru',
    '59.ru',
    'v1.ru',
    '161.ru',
    '76.ru',
    '29.ru',
    '45.ru',
    '116.ru',
    '56.ru',
    '93.ru',
    'tolyatty.ru',
    '164.ru',
    '26.ru',
    '48.ru',
    '51.ru',
    '178.ru',
    'mgorsk.ru',
    '62.ru',
    '86.ru',
    '70.ru',
    'irkutsk138.ru',
    '43.ru',
    'proizhevsk.ru',
    '42.ru',
    '89.ru',
    '154.ru',
    '14.ru',
    '35.ru',
    '71.ru',
    '68.ru',
    '53.ru',
    '60.ru',
    'sterlitamak1.ru',
    'sochi1.ru',
    'provoronezh.ru',
    'fontanka.ru',
    'doctorpiter.ru'
);

INSERT INTO `//home/vipplanners/yanpartners/all/hsm/clicks_dataset_2` WITH TRUNCATE
SELECT
    $to_start_month(report_date) AS month,
    report_date,
    IF(domain_root IN $federal_domanis, 'FEDERAL', 'REGIONAL') AS domain_segment,
    domain_root,
    device_type,
    -- https://st.yandex-team.ru/ADVERTANALYTICS-4000#5ad9aba96aa96e001a4cf793
    network,
    SUM(clicks)
FROM
    -- https://github.yandex-team.ru/chaos-ad/etl_new/blob/master/etl/yt/stats/clickgen_stats.py#L97
    `//home/comdep-analytics/chaos-ad/logs/bs/clickgen_stats/all`
WHERE
    report_date >= $minus_n_days($commit_start, 28) AND
    (domain_root IN $federal_domanis OR
    domain_root IN $regional_domains)
GROUP BY
    report_date,
    domain_root,
    IF(device_type == 3, 'Mobile', 'Desktop')   AS device_type,
    network
ORDER BY
    report_date,
    domain_root;
