use hahn;

PRAGMA DisableAnsiInForEmptyOrNullableItemsCollections;

IMPORT direct SYMBOLS
    $ad_and_crypta_direct
    ;

IMPORT geo SYMBOLS 
    $ad_table_all_date_geo
    ;

IMPORT post_campaign_lib SYMBOLS 
    $uniq_list_uint64,
    $make_elements,
    $return_string_ad
    ;

------------------------------------------------------------------------------------------------------------------------
--                                              Объединяем данные из разных источников
------------------------------------------------------------------------------------------------------------------------

DEFINE SUBQUERY $ad_claer_table() as 
    SELECT *
    FROM AS_TABLE(ListCreate(Struct<group_list: List<String?>, bgl: List<String?>, RegionsList: List<String>, countertype: int64?, campaign_type: String , content_type: String?, contexttype: int64?, device_type: String, product_category: string?, UserID: Uint64, uniq_coverage: Uint64, logid: uint64?, eventtime_ts: date, Clicks: int64?, Shows: int64?, Cost: double?, age: String?, gender: String?, income: String?, shortterm_interests: List<Int32?>, longterm_interests: List<Int64?>, heuristic_common: List<Int64?> > ))
END DEFINE;

DEFINE SUBQUERY $ad_data_all_direct($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id) as 

    SELECT * FROM $ad_claer_table()
    UNION ALL
    SELECT * FROM $ad_and_crypta_direct($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)

END DEFINE;

DEFINE SUBQUERY $ad_data_all_geo($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id) as 
    
    SELECT * FROM $ad_claer_table()
    UNION ALL
    SELECT * FROM $ad_table_all_date_geo($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)

END DEFINE;

DEFINE SUBQUERY $ad_data_geo_and_direct($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id) as 
    
    SELECT * FROM $ad_claer_table()
    UNION ALL
    SELECT * FROM $ad_and_crypta_direct($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)
    UNION ALL
    SELECT * FROM $ad_table_all_date_geo($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)

END DEFINE;


DEFINE SUBQUERY $ad_data_all_finish($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id) as 

$need_direct = SELECT ListHasItems($uniq_list_uint64($make_elements($campaign_and_group, 'black_campaign_ids'))) OR ListHasItems($uniq_list_uint64($make_elements($campaign_and_group, 'campaign_ids'))) OR ListHasItems($uniq_list_uint64($make_elements($campaign_and_group, 'group_ids'))) OR ListHasItems($uniq_list_uint64($make_elements($campaign_and_group, 'black_group_ids')))
;

$need_geo = SELECT ListHasItems($uniq_list_uint64($make_elements($campaign_and_group, 'geo'))) OR ListHasItems($uniq_list_uint64($make_elements($campaign_and_group, 'black_geo')));

$need_ad_fox = SELECT ListHasItems($uniq_list_uint64($make_elements($campaign_and_group, 'ad_fox'))) OR ListHasItems($uniq_list_uint64($make_elements($campaign_and_group, 'black_ad_fox')));


$result = EvaluateCode(CASE true
                        WHEN $need_direct and $need_geo THEN QuoteCode($ad_data_geo_and_direct) -- ГЕО + Директ
                        WHEN $need_direct THEN QuoteCode($ad_data_all_direct) -- Директ
                        WHEN $need_geo THEN QuoteCode($ad_data_all_geo) -- ГЕО
                        ELSE QuoteCode($ad_claer_table)
                        END
                                    
                                    );

SELECT *
FROM $result($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)

END DEFINE;

------------------------------------------------------------------------------------------------------------------------
--                                              Форматируем под единый формат
------------------------------------------------------------------------------------------------------------------------

DEFINE SUBQUERY $ad_all_data($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id) AS 

    $black_list_corrected =
        SELECT 
        AGGREGATE_LIST_DISTINCT (bgl) as bl,
        UserID,
        RegionsList
        FROM (
            SELECT    
                bgl,
                UserID,
                RegionsList
                FROM $ad_data_all_finish($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)
            GROUP BY
            bgl,
            UserID,
            RegionsList
            )
        GROUP BY UserID, RegionsList
    ;

    SELECT
            group_list,
            ListUniq(ListFlatten(bl.bl)) as black_group_list,
            ad_data.RegionsList as RegionsList,
            countertype,
            campaign_type,
            content_type,
            contexttype,
            device_type,
            product_category,
            ad_data.UserID as UserID,
            uniq_coverage,
            logid,
            eventtime_ts ,
            Clicks,
            Shows,
            Cost,

            age,
            gender,
            income,
            shortterm_interests,
            longterm_interests,
            heuristic_common
    FROM $ad_data_all_finish($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id) as ad_data
    JOIN $black_list_corrected as bl
    ON ad_data.UserID = bl.UserID and ad_data.RegionsList = bl.RegionsList
    ;

END DEFINE;

DEFINE SUBQUERY $ad_user_black($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id) AS 

    SELECT DISTINCT UserID, group_name
    FROM (
        SELECT UserID, group_name
        FROM $ad_all_data($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)
        FLATTEN LIST BY (black_group_list as group_name)
        UNION ALL
        SELECT UserID, group_name
        FROM $ad_all_data($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)
        FLATTEN LIST BY (group_list as group_name)
        )
    ;
END DEFINE;

<<<<<<< client_method/post_campaign/connect_ad.sql
DEFINE SUBQUERY $data_path_ad($to_start_output, $regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear) AS 
=======
DEFINE SUBQUERY $data_path_ad($to_start_output, $regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $date_table, $geo_clear, $input_mm_device_id) AS 
>>>>>>> client_method/post_campaign/connect_ad.sql

    $ad_stat =
        SELECT
            group_ad,
            regions,
            min(DateTime::MakeDate(DateTime::StartOfDay(cast(SUBSTRING(CAST(AddTimezone(eventtime_ts, "Europe/Moscow") as String),0,10) as date)))) OVER w as start_date,
            max(DateTime::MakeDate(DateTime::StartOfDay(cast(SUBSTRING(CAST(AddTimezone(eventtime_ts, "Europe/Moscow") as String),0,10) as date)))) OVER w as end_date,
            campaign_type,
            content_type,
            device_type,
            product_category,
            Clicks,
            Shows,
            Cost,
            uniq_coverage,
            eventtime_ts
        FROM $ad_data_all_finish($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)
        FLATTEN LIST BY (group_list as group_ad, RegionsList as regions)
        WINDOW w as (PARTITION BY group_ad, regions)
    ;

    $uniq_user = 
        SELECT
            group_ad,
            regions,
            count (distinct uniq_coverage) AS uniq_ad_group
        FROM $ad_stat
        GROUP BY 
            group_ad,
            regions
    ;

    $good_date =
        SELECT
            dt.dt as dt,
            uniq.group_ad as group_ad,
            uniq.regions as regions,
            uniq.uniq_ad_group as uniq_ad_group
        FROM $date_table() as dt
        CROSS JOIN $uniq_user as uniq
    ;

    $all_data_connect =
        SELECT 
            `Date`,
            group_ad,
            regions,
            start_date,
            end_date,
            $return_string_ad($campaign_and_group, group_ad, 'group_ids') as group_direct,
            $return_string_ad($campaign_and_group, group_ad, 'campaign_ids') as campaign_direct,
            $return_string_ad($campaign_and_group, group_ad, 'geo') as campaign_geo,
            $return_string_ad($campaign_and_group, group_ad, 'ad_fox') as campaign_adfox,
            campaign_type,
            content_type,
            device_type,
            product_category,
            sum(Clicks) as clicks,
            sum(Shows) as shows,
            sum(Cost) as Cost,
            count (distinct ad.uniq_coverage) as uniq_row,
            max(uniq_ad_group) as uniq_ad_group
    FROM $good_date as uniq
    LEFT JOIN $ad_stat as ad
    ON uniq.group_ad = ad.group_ad AND uniq.regions = ad.regions AND $to_start_output(ad.eventtime_ts) = uniq.dt
    GROUP BY
            uniq.dt as `Date`,
            ad.group_ad as group_ad,
            ad.regions as regions,
            ad.campaign_type as campaign_type,
            ad.content_type as content_type,
            ad.device_type as device_type,
            ad.product_category as product_category,
            ad.start_date as start_date,
            ad.end_date as end_date
    ;

    $gd =
    SELECT
        max(`Date`) as max_dt,
        min(`Date`) as min_dt,
        group_ad,
        regions
    FROM $all_data_connect
    WHERE
        (clicks is not null
        OR shows is not null
        OR Cost is not null)
    GROUP BY
        group_ad,
        regions
    ;

    SELECT 
            `Date`,
            ad.group_ad as group_ad,
            ad.regions as regions,
            start_date,
            end_date,
            group_direct,
            campaign_direct,
            campaign_geo,
            campaign_adfox,
            campaign_type,
            content_type,
            device_type,
            product_category,
            clicks ?? 0 as clicks,
            shows ?? 0 as shows,
            Cost ?? 0.0 as Cost,
            uniq_row,
            uniq_ad_group
    FROM $all_data_connect as ad
    JOIN $gd as gd
    ON ad.group_ad = gd.group_ad AND ad.regions = gd.regions
    WHERE 1=1
    AND max_dt >= `Date`
    AND `Date` >= min_dt


END DEFINE;

EXPORT 
    $ad_user_black,
    $ad_all_data,
    $data_path_ad,
    $ad_data_all_finish
    ;
