use hahn;

IMPORT connect_ad SYMBOLS 
    $ad_all_data;

    DEFINE SUBQUERY $for_control_lift($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $interval, $geo_clear, $input_mm_device_id) AS 
        $groupped_users =
        SELECT 
            group_list,
            RegionsList,
            UserID,
            session_start,
            (max(DateTime::ToSeconds(eventtime_ts))+DateTime::ToSeconds($interval))-min(DateTime::ToSeconds(eventtime_ts)) as interval_second
        FROM $ad_all_data($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)
        GROUP BY
            group_list,
            RegionsList,
            UserID,
            SessionWindow(DateTime::ToSeconds(eventtime_ts), DateTime::ToSeconds($interval)) as session_start
        ;

        $interva_and_start_control =
        SELECT 
            group_name,
            region_name,
            UserID,
            cast (min(session_start) as double) as first_view,
            cast (sum(interval_second) as double) as interval_second
        FROM $groupped_users
        FLATTEN BY (group_list as group_name, RegionsList as region_name)
        GROUP BY
            group_name,
            region_name,
            UserID
        ;

        SELECT 
            group_name,
            region_name,
            PERCENTILE (first_view, 0.2) as first_percentile,
            avg(interval_second) as interval_avg,
            PERCENTILE (first_view, 0.2) + PERCENTILE(interval_second, 0.8) as last_avg
        FROM $interva_and_start_control
        GROUP BY
            group_name,
            region_name
        ;
    END DEFINE;

EXPORT 
$for_control_lift
;
