USE hahn;

PRAGMA DisableAnsiInForEmptyOrNullableItemsCollections;
------------------------------------------------------------------------------------------------------------------------
--                                              Данные директа
------------------------------------------------------------------------------------------------------------------------

IMPORT post_campaign_lib SYMBOLS 
    $uniq_list_uint64,
    $make_elements,
    $campaign_peridact,
    $return_group_by_id,
    $name_geo_by_id,
    $content_type_peridact;

DEFINE SUBQUERY $ad_table_all_date_direct($regions_task, $campaign_and_group, $add_vat, $direct_clear, $input_qa_region_id) AS 

    $direct_table_first = 
        SELECT 
            *
        FROM $direct_clear()
    ;

        SELECT
            group_list,
            bgl,
            campaign_type,
            content_type,
            countertype,
            contexttype,
            device_type,
            product_category,
            uniq_coverage,
            logid,
            yandexuid,
            groupexportid,
            RegionsList,
            uniqid,
            eventtime_ts,
            SUM(direct.Clicks) as Clicks,
            SUM(direct.Shows) as Shows,
            SUM(direct.Cost) as Cost
        FROM $direct_table_first as direct
        JOIN $input_qa_region_id as geo
        ON direct.regionid = geo.RegionID
        WHERE 1=1
        AND ListHasItems($name_geo_by_id(geo.TargetRegionID, $regions_task))
        GROUP BY
            direct.group_list as group_list,
            direct.black_group_list as bgl,
            direct.campaign_type as campaign_type,
            direct.content_type as content_type,
            direct.countertype as countertype,
            direct.contexttype as contexttype,
            direct.device_type_ru as device_type,
            direct.product_category as product_category,
            direct.uniq_coverage as uniq_coverage,
            direct.logid as logid,
            direct.yandexuid as yandexuid,
            direct.groupexportid as groupexportid,
            direct.uniqid as uniqid,
            direct.eventtime_ts as eventtime_ts,
            $name_geo_by_id(geo.TargetRegionID, $regions_task) as RegionsList
    ;

END DEFINE;

DEFINE SUBQUERY $ad_and_crypta_direct($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id) AS 

        SELECT
            group_list,
            bgl,
            RegionsList,
            countertype,
            campaign_type,
            content_type,
            contexttype,
            device_type,
            product_category,
            agi.crypta_id??ad_data.yandexuid as UserID,
            uniq_coverage,
            logid,
            eventtime_ts,
            Clicks,
            Shows,
            Cost,

            age,
            gender,
            income,
            shortterm_interests,
            longterm_interests,
            heuristic_common
        FROM $ad_table_all_date_direct($regions_task, $campaign_and_group, $add_vat, $direct_clear, $input_qa_region_id) as ad_data
        LEFT JOIN $crypta_clear() as agi
            ON ad_data.yandexuid = agi.yandexuid
    ;

END DEFINE;

DEFINE SUBQUERY $ad_table_video($regions_task, $campaign_and_group, $add_vat, $direct_clear, $input_qa_region_id) AS

    SELECT group_list, groupexportid, product_category
    FROM $ad_table_all_date_direct($regions_task, $campaign_and_group, $add_vat, $direct_clear, $input_qa_region_id)
    WHERE ListLength(group_list) > 0
    AND product_category = 'video'
    GROUP BY group_list, groupexportid, product_category
    ;

END DEFINE;

EXPORT 
    $ad_table_video,
    $ad_and_crypta_direct;
