USE hahn;

PRAGMA DisableAnsiInForEmptyOrNullableItemsCollections;

IMPORT post_campaign_lib SYMBOLS 
    $name_geo_by_id
    ;
------------------------------------------------------------------------------------------------------------------------
--                                              Данные ГЕО
------------------------------------------------------------------------------------------------------------------------

DEFINE SUBQUERY $ad_table_all_date_geo($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id) AS 

    $geo_table_first = 
        SELECT 
            *
        FROM $geo_clear()
    ;

    SELECT 
        group_list,
        bgl,
        RegionsList,
        uniq_coverage,
        UserID,
        eventtime_ts,
        'ГЕО реклама' as campaign_type,
        'Смартфоны' as device_type,
        Shows,
        Clicks,
        Cost
    FROM $geo_table_first as geo
    JOIN $input_qa_region_id as geo_task
    ON geo.regionid = geo_task.RegionID
    LEFT JOIN $input_mm_device_id as crypta
    ON geo.device_id = crypta.id
    WHERE 1=1
    AND ListHasItems($name_geo_by_id(geo_task.TargetRegionID, $regions_task))
    GROUP BY
        geo.group_list as group_list,
        cast (crypta.target_id as Uint64) as UserID,
        geo.black_group_list as bgl,
        geo.device_id as uniq_coverage,
        geo.eventtime_ts as eventtime_ts,
        geo.shows as Shows,
        geo.clicks as Clicks,
        geo.cost as Cost,
        $name_geo_by_id(geo_task.TargetRegionID, $regions_task) as RegionsList
    

END DEFINE;

EXPORT 
    $ad_table_all_date_geo;
