USE hahn;

PRAGMA DisableAnsiInForEmptyOrNullableItemsCollections;

IMPORT post_campaign_lib SYMBOLS 
    $uniq_list_uint64,
    $return_group_by_id,
    $make_elements,
    $goals_chek,
    $return_list_goal
    ;
------------------------------------------------------------------------------------------------------------------------
--                                              Метрика
------------------------------------------------------------------

DEFINE SUBQUERY $metrika($input_metrica_currency_rates, $date_start_curr, $use_up_lift, $filtred_metrika, $counter_and_goals, $crypta_clear) AS 

        --перевод Метричных дохов в рубли
    $convert_revenue_to_rub = ($purchses, $rates) -> {
        RETURN
            ListMap($purchses, ($revenue) -> {RETURN $revenue.1 / $rates[$revenue.0] * $rates['RUB'] / 1000000})
    };

    $metrika_parse = (
        SELECT
            *
        FROM $filtred_metrika()

    );

    -- Метричные валюты для конвертации дохода
    $metrica_currecy_rates =
        SELECT 
            DateTime::ToSeconds(CAST(rate_date AS Date)) AS rate_date_sec,
            rate_in_usd
        FROM $input_metrica_currency_rates
        WHERE 1=1
            AND  rate_date >= $date_start_curr
        ;

    $metrika_raw = (
        SELECT
            m.*,
            crypta_ids.crypta_id??m.yandexuid as UserID,
            ListSum($convert_revenue_to_rub(m.epurchase_with_currency, cur.rate_in_usd)) AS Revenue,
            age,
            gender,
            income,
            shortterm_interests,
            longterm_interests,
            heuristic_common
        FROM $metrika_parse as m
        LEFT JOIN $crypta_clear() as crypta_ids
            ON m.yandexuid = crypta_ids.yandexuid
        LEFT JOIN $metrica_currecy_rates as cur
            ON DateTime::ToSeconds(DateTime::MakeDate(m.SessStart_ts)) = cur.rate_date_sec
        );

        SELECT
            group_metrika,
            VisitID,
            UserID,
            MIN(SessStart_ts) as SessStart_ts,
            CAST(SUM(Duration) AS double) / 86400.0 as Duration,
            SUM(Hits) as page_views,
            SUM(bounce) as bounce,
            Goals_IDs_List,
            IF($goals_chek(Goals_IDs_List, $return_list_goal($counter_and_goals, group_metrika)) > 0, 1, 0) AS converted_session,
            IF (SUM (EPurchases) > 0, 1, 0)  AS EPurchases,  -- покупки по екому
            SUM (Revenue) * 1.0 as Revenue, -- доход по екому
            ClickLogID,
            RegionID,

            age,
            gender,
            income,
            shortterm_interests,
            longterm_interests,
            heuristic_common

        FROM $metrika_raw
        FLATTEN BY group_list_metrika as group_metrika
        GROUP BY
            group_metrika,
            RegionID,
            VisitID,
            UserID,
            Goals_IDs_List,
            ClickLogID,

            age,
            gender,
            income,
            shortterm_interests,
            longterm_interests,
            heuristic_common
    ;

END DEFINE;

EXPORT 
    $metrika;
