PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$make_id_list_uint64 = ($dict_item) -> {RETURN ListMap(String::SplitToList($dict_item, ','), ($x) -> {RETURN CAST($x AS Uint64)})}; -- возвращаем списком данные из форм

$goals_chek = ($goals_in_table, $goals_in_form) -> {RETURN ListLength(ListFilter($goals_in_table, ($x) -> {RETURN $x in $goals_in_form}))};

$return_group_by_id = ($table, $row, $row_column, $table_column) -> {
    RETURN ListNotNull (ListMap($table, ($x) -> {
        RETURN 
            CASE
                WHEN cast($row.$row_column as Uint64) IN $make_id_list_uint64($x[$table_column]) THEN $x['category']
                ELSE null
            END
    
    }))
}; -- возвращаем категорию при совпадении данных

$return_list_goal = ($table, $column) -> {
    RETURN ListFlatten (ListNotNull (ListMap($table, ($x) -> {
        RETURN 
            CASE
                WHEN $x['category'] = $column THEN CAST(String::SplitToList($x['goal_ids'], ',') as List<Uint64>)
                ELSE null
            END
    
    })))
}; -- возвращаем лист с целями для каждой группы

$return_string_ad = ($table, $column, $column_ad) -> {
    RETURN String::JoinFromList(ListNotNull(ListMap($table, ($x) -> {
        RETURN if ($x['category'] = $column, $x[$column_ad], null)
    
    })), ', ')
}; -- возращает изначальный список, который задавал пользователь

$return_org_name_list = ($table, $org_name) -> {
    RETURN ListFlatten(ListNotNull(ListMap($table, ($x) -> {
        RETURN 
            CASE
                WHEN 
                $org_name IN $x['link_name']
                THEN $x['org_name']
                ELSE null
            END
    })))
}; -- Возвращаем, к какой группе организаций это относится.

$make_elements = ($type_table, $column) -> {RETURN ListMap($type_table, ($x) -> {RETURN String::SplitToList($x[$column], ',')})}; -- Извлекаем все элементы из словаря в список

$make_elements_cg = ($type_table, $column) -> {RETURN ListMap($type_table, ($x) -> {RETURN $x[$column]})}; -- Извлекаем все элементы из словаря в список

$uniq_list_uint64 = ($table) -> {RETURN CAST(ListUniq(ListFlatten($table)) as List<Uint64>)};

$uniq_list = ($table) -> {RETURN ListUniq(ListFlatten($table))};


-- Фильтрация гео по списку ID
$name_geo_by_id = ($r, $task_regions) -> {
    RETURN 
        ListNotNull(ListMap($task_regions, ($set) -> {RETURN IF($r IN $set.1, $set.0, null)}))
};
-- возвращаем все названия ГЕО из задания.
$geo_name = ($geo) -> { RETURN ListMap($geo, ($item) -> { RETURN $item.0 })};

$lt_list_row = ($longterm_interests) -> {RETURN Yson::ConvertToInt64List($longterm_interests)};

$st_list_row = ($shortterm_interests) -> {RETURN ListMap(DictKeys(Yson::ConvertToInt64Dict($shortterm_interests)),($key) -> {RETURN CAST($key AS Int32)})};

$heuristic_common = ($heuristic_common) -> {RETURN Yson::ConvertToInt64List($heuristic_common)};

$ListIntersectAny = ($lst1, $lst2) -> {RETURN ListLength(SetIntersection(ToSet($lst1), ToSet($lst2))) > 0}; -- возвращаем если есть хоть одно совпадение.

$return_control_group = ($table, $gender, $age, $income, $short, $long, $heurcistic_cammon) -> {
    RETURN ListFlatten(ListNotNull (ListMap($table, ($x) -> {
        RETURN 
            CASE
                WHEN 
                IF (ListLength($x['gender']) = 0, true , $gender IN $x['gender'])
                AND IF (ListLength($x['age']) = 0, true , $age IN $x['age'])
                AND IF (ListLength($x['income']) = 0, true , $income IN $x['income'])

                AND IF (ListLength($x['any']) = 0, true , $ListIntersectAny (cast ($short as List<String>), cast ($x['any'] as List<String>)) or $ListIntersectAny (cast ($long as List<String>), cast ($x['any'] as List<String>)))

                AND IF (ListLength($x['short']) = 0, true , $ListIntersectAny (cast ($short as List<String>), cast ($x['short'] as List<String>)))

                AND IF (ListLength($x['long']) = 0, true , $ListIntersectAny (cast ($long as List<String>), cast ($x['long'] as List<String>)))

                AND IF (ListLength($x['married']) = 0, true , $ListIntersectAny (cast ($heurcistic_cammon as List<String>), cast ($x['married'] as List<String>)))

                AND IF (ListLength($x['kids']) = 0, true , $ListIntersectAny (cast ($heurcistic_cammon as List<String>), cast ($x['kids'] as List<String>)))

                AND IF (ListLength($x['prof']) = 0, true , $ListIntersectAny (cast ($heurcistic_cammon as List<String>), cast ($x['prof'] as List<String>)))

                THEN $x['control']
                ELSE null
            END
    })))
}; -- Возвращаем, к какой контрольной группе это относится.

-- разделяем на типы РК по предикатам
$campaign_peridact = ($r) -> {RETURN 
CASE 
    WHEN $r.campaign_type = 'mobile_content' then "РМП"
    WHEN $r.campaign_type = 'mcbanner' then "Баннер на поиске"
    WHEN $r.campaign_type = 'performance' THEN "Смарт-баннеры"
    WHEN $r.campaign_type = 'dynamic' THEN "Динамические объявления"
    WHEN $r.campaign_type = 'cpm_yndx_frontpage' then "Баннер на главной"
    WHEN $r.campaign_type = 'cpm_price' and ($r.cpm_price_available_ad_group_types = 'cpm_audio' or $r.banner_type = 'cpm_audio') then "Аудиореклама"
    WHEN ($r.campaign_type = 'cpm_price' and ($r.cpm_price_available_ad_group_types = 'cpm_video' or $r.banner_type = 'cpm_video' or $r.product_category = 'video')) or $r.product_category = 'video' then "Видео"
    WHEN $r.campaign_type = 'cpm_price' and ($r.cpm_price_available_ad_group_types = 'cpm_yndx_frontpage' or $r.banner_type = 'cpm_yndx_frontpage') then "Баннер на главной"
    WHEN $r.campaign_type = 'cpm_price' and ($r.cpm_price_available_ad_group_types = 'cpm_banner' or $r.banner_type = 'cpm_banner') then "Баннеры на сервисах Яндекса"
    WHEN $r.campaign_type = 'cpm_banner' then "Медийные баннеры"
    WHEN $r.campaign_type = 'content_promotion' then "Продвижение контента"
    WHEN $r.campaign_type = 'cpm_deals' then "Частные сделки"
    WHEN $r.campaign_type = 'text' and $r.campaignmetatype != 1 then "Текстово-графические объявления"
    WHEN $r.campaignmetatype = 1 then "Товарные кампании"
    ELSE "Если ты знаешь, что я такое расскажи мне"
END };

-- разделяем на типы контента по предикатам
$content_type_peridact = ($r) -> {RETURN 
CASE 
    WHEN $r.producttype in ('media-creative', 'media-creative-reach', 'media-image', 'media-smart')
        and $r.`orderbanneroptions_video-in-banner` then "Видеобаннеры"
    WHEN $r.producttype in ('media-creative', 'media-creative-reach', 'media-image', 'media-smart')
        and not $r.`orderbanneroptions_video-in-banner` then "Графические объявления (Без видеобаннеров)"
    WHEN $r.producttype in ('media-creative', 'media-creative-reach', 'media-image', 'media-smart') then "Графические объявления"
    WHEN $r.producttype in ('audio-creative-reach') then "Аудиореклама"
    WHEN $r.impressionoptions_rewarded and $r.producttype in ('auto-video-direct', 'video-creative', 'video-creative-reach', 'video-creative-reach-indoor','video-creative-reach-non-skippable', 'video-creative-reach-outdoor','video-creative-survey', 'video-motion', 'video-smart') then "Видеообъявления (С вознаграждением)"
    WHEN not $r.impressionoptions_rewarded
                         and not ($r.impressionoptions_interstitial 
                               or $r.impressionoptions_fullscreen 
                               or $r.impressionoptions_native)
                         and ($r.impressionoptions_inroll
                           or $r.`impressionoptions_inroll-overlay`
                           or $r.impressionoptions_midroll
                           or $r.impressionoptions_overlay
                           or $r.impressionoptions_preroll
                           or $r.impressionoptions_pauseroll
                           or $r.impressionoptions_postroll
                           or $r.`impressionoptions_postroll-overlay`
                           or $r.`impressionoptions_postroll-wrapper`
                           or $r.impressionoptions_s2sroll)
                          and $r.producttype in ('auto-video-direct', 
                                                'video-creative', 
                                                'video-creative-reach', 
                                                'video-creative-reach-indoor',
                                                'video-creative-reach-non-skippable',
                                                'video-creative-reach-outdoor',
                                                'video-creative-survey',
                                                'video-motion',
                                                'video-smart') then "Видеообъявления (В потоковом видео)"
    WHEN $r.impressionoptions_inpage
                         and not $r.impressionoptions_rewarded
                         and not $r.impressionoptions_interstitial
                         and $r.producttype in ('auto-video-direct', 
                                                'video-creative', 
                                                'video-creative-reach', 
                                                'video-creative-reach-indoor',
                                                'video-creative-reach-non-skippable',
                                                'video-creative-reach-outdoor',
                                                'video-creative-survey',
                                                'video-motion',
                                                'video-smart') then "Видеообъявления (В текстовом контенте)"
    WHEN $r.impressionoptions_inbanner
                         and not $r.impressionoptions_rewarded
                         and not ($r.impressionoptions_interstitial
                                  or $r.impressionoptions_fullscreen
                                  or $r.impressionoptions_native)
                         and $r.producttype in ('auto-video-direct', 
                                                'video-creative', 
                                                'video-creative-reach', 
                                                'video-creative-reach-indoor',
                                                'video-creative-reach-non-skippable',
                                                'video-creative-reach-outdoor',
                                                'video-creative-survey',
                                                'video-motion',
                                                'video-smart') then "Видеообъявления (В баннере)"
    WHEN not $r.impressionoptions_rewarded
                         and not $r.impressionoptions_interstitial
                         and not $r.impressionoptions_fullscreen
                         and not $r.impressionoptions_inpage
                         and not $r.impressionoptions_native
                         and not $r.impressionoptions_inbanner
                         and not $r.impressionoptions_inroll
                         and not $r.`impressionoptions_inroll-overlay`
                         and not $r.impressionoptions_midroll
                         and not $r.impressionoptions_overlay
                         and not $r.impressionoptions_preroll
                         and not $r.impressionoptions_pauseroll
                         and not $r.`impressionoptions_postroll-overlay`
                         and not $r.impressionoptions_s2sroll
                         and $r.`impressionoptions_is-ssp`
                         and $r.producttype in ('auto-video-direct', 
                                                  'video-creative', 
                                                  'video-creative-reach',
                                                  'video-creative-reach-indoor',
                                                  'video-creative-reach-non-skippable',
                                                  'video-creative-reach-outdoor',
                                                  'video-creative-survey',
                                                  'video-motion',
                                                  'video-smart') then "Видеообъявления (Видео в ssp)"
    WHEN not $r.impressionoptions_rewarded
                         and ($r.impressionoptions_interstitial or $r.impressionoptions_fullscreen or $r.impressionoptions_native)
                         and  $r.producttype in ('auto-video-direct', 
                                                 'video-creative', 
                                                 'video-creative-reach', 
                                                 'video-creative-reach-indoor',
                                                 'video-creative-reach-non-skippable',
                                                 'video-creative-reach-outdoor',
                                                 'video-creative-survey',
                                                 'video-motion',
                                                 'video-smart') then "Видеообъявления (В приложениях)"
    WHEN $r.tgavideocreativeid > 0
                         and $r.`orderbanneroptions_video-tga`
                         and $r.producttype = 'direct' then "Видеообъявления (в ТГО)"
    WHEN not $r.impressionoptions_rewarded
                          and $r.producttype in ('auto-video-direct', 
                                                'video-creative', 
                                                'video-creative-reach', 
                                                'video-creative-reach-indoor',
                                                'video-creative-reach-non-skippable',
                                                'video-creative-reach-outdoor',
                                                'video-creative-survey',
                                                'video-motion',
                                                'video-smart') then "Видеообъявления (Остальное)"
    WHEN $r.producttype = 'direct' then "Текстово-графические объявления"
    ELSE "Если ты знаешь, что я такое расскажи мне"
END 
};


EXPORT 
    $st_list_row, 
    $lt_list_row, 
    $heuristic_common, 
    $uniq_list_uint64, 
    $make_elements, 
    $return_group_by_id, 
    $goals_chek, 
    $return_list_goal, 
    $name_geo_by_id,
    $geo_name,
    $return_control_group, 
    $uniq_list, 
    $make_elements_cg,
    $campaign_peridact,
    $return_string_ad,
    $return_org_name_list,
    $content_type_peridact
    ;
