use hahn;

PRAGMA AnsiInForEmptyOrNullableItemsCollections;

IMPORT connect_ad SYMBOLS 
    $ad_all_data,
    $ad_user_black;

IMPORT metrika SYMBOLS 
    $metrika;
------------------------------------------------------------------------------------------------------------------------
--                                              Реклама и метрика тест
------------------------------------------------------------------------------------------------------------------------

DEFINE SUBQUERY $pv_data_metrika($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $input_metrica_currency_rates, $use_up_lift, $counter_and_goals, $time_filter, $filtred_metrika, $crypta_clear, $direct_clear, $date_start_curr, $geo_clear, $input_mm_device_id) AS 

$ads_for_metrika = (
    SELECT 
        UserID,
        black_group_list,
        group_list,
        RegionsList,
        campaign_type,
        content_type,
        device_type,
        product_category,
        countertype,
        logid,
        eventtime_ts
    FROM $ad_all_data($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)
);

    $test_group_direct = (
        SELECT
            group_metrika,
            group_list,
            VisitID,
            m.UserID as UserID,
            "Прямой" as type_group,
            countertype,
            RegionsList,
            campaign_type,
            content_type,
            device_type,
            product_category,
            SessStart_ts,
            eventtime_ts,
            Duration,
            page_views,
            bounce,
            converted_session,
            EPurchases,
            Revenue,
            1 as tf,
            black_group_list,
            ClickLogID
        FROM $ads_for_metrika as ad
        JOIN $metrika($input_metrica_currency_rates, $date_start_curr, $use_up_lift, $filtred_metrika, $counter_and_goals, $crypta_clear) as m
        ON ad.logid = m.ClickLogID
    );

-- Надо сделать добавление в контроль старых данных для прямых на основе UserID.

    $black_visits_direct = (
        SELECT DISTINCT 
            VisitID
        FROM $test_group_direct
        WHERE ListHasItems(group_list)
    );

    $test_group_post_view = (
        SELECT
            group_metrika,
            group_list,
            VisitID as Visits,
            UserID,
            IF (countertype = 2, "Post-click", "Post-view") as type_group,
            countertype,
            RegionsList,
            campaign_type,
            content_type,
            device_type,
            product_category,
            SessStart_ts,
            eventtime_ts,
            Duration,
            page_views,
            bounce,
            converted_session,
            EPurchases,
            Revenue,
            black_group_list,
            IF ($time_filter(ad.eventtime_ts, m.SessStart_ts), 1, 0) as tf,
            null as ClickLogID
        FROM $ads_for_metrika as ad
        JOIN $metrika($input_metrica_currency_rates, $date_start_curr, $use_up_lift, $filtred_metrika, $counter_and_goals, $crypta_clear) as m
            ON ad.UserID = m.UserID
        LEFT ONLY JOIN $black_visits_direct as b
            ON b.VisitID = m.VisitID
        WHERE ListHasItems(group_list)
        GROUP BY
            m.group_metrika as group_metrika,
            ad.black_group_list as black_group_list,
            m.VisitID as VisitID,
            ad.UserID as UserID,
            ad.group_list as group_list,
            ad.countertype as countertype,
            ad.RegionsList as RegionsList,
            ad.campaign_type as campaign_type,
            ad.content_type as content_type,
            ad.device_type as device_type,
            ad.product_category as product_category,
            m.SessStart_ts as SessStart_ts,
            ad.eventtime_ts as eventtime_ts,
            m.Duration as Duration,
            m.page_views as page_views,
            m.bounce as bounce,
            m.converted_session as converted_session,
            m.EPurchases as EPurchases,
            m.Revenue as Revenue
    );

    $min_time = (
        SELECT
        Visits,
        max(eventtime_ts) as max_time,
        tf
        FROM $test_group_post_view
        GROUP BY
        Visits,
        tf
    );

    $filtred_post_view = (
        SELECT
        Visits,
        "Post-view" as type_group,
        tf
        FROM $test_group_post_view
        WHERE 1=1
        AND type_group = "Post-click"
        GROUP BY
        Visits,
        tf
    );

        SELECT
            group_metrika,
            group_list,
            UserID,
            type_group,
            countertype,
            RegionsList,
            campaign_type,
            content_type,
            device_type,
            product_category,
            Visits,
            Duration,
            page_views,
            bounce,
            converted_session,
            EPurchases,
            SessStart_ts,
            IF (tf = 0, SessStart_ts, eventtime_ts) as eventtime_ts,
            Revenue,
            tf,
            black_group_list,
            ClickLogID
        FROM $test_group_post_view as pv
        LEFT SEMI JOIN $min_time as t
        ON t.Visits == pv.Visits and t.max_time == pv.eventtime_ts and t.tf == pv.tf
        LEFT ONLY JOIN $filtred_post_view as f
        ON f.Visits == pv.Visits and f.type_group == pv.type_group and f.tf == pv.tf

        UNION ALL

            SELECT 
            group_metrika,
            group_list,
            UserID,
            type_group,
            countertype,
            RegionsList,
            campaign_type,
            content_type,
            device_type,
            product_category,
            VisitID as Visits,
            Duration,
            page_views,
            bounce,
            converted_session,
            EPurchases,
            SessStart_ts,
            IF (tf = 0, SessStart_ts, eventtime_ts) as eventtime_ts,
            Revenue,
            tf,
            black_group_list,
            ClickLogID
            FROM $test_group_direct
        ;

END DEFINE;

DEFINE SUBQUERY $data_path_pv_metrika($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $input_metrica_currency_rates, $use_up_lift, $counter_and_goals, $time_filter, $filtred_metrika, $crypta_clear, $black_list_all, $direct_clear, $date_start_curr, $date_table, $to_start_output, $geo_clear, $input_mm_device_id) AS 

    $metriks_date =
    SELECT 
        `Date`,
        group_metrika,
        group_name,
        type_group,
        regions,
        device_type,
        campaign_type,
        content_type,
        product_category,
        count(distinct Visits) as Visits,
        sum(cast (Duration as double)) as duration,
        sum(page_views) as page_views,
        sum(bounce) as bounce,
        sum(converted_session) as converted_session,
        sum(EPurchases) as EPurchases,
        sum(Revenue) as Revenue
    FROM $pv_data_metrika($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $input_metrica_currency_rates, $use_up_lift, $counter_and_goals, $time_filter, $filtred_metrika, $crypta_clear, $direct_clear, $date_start_curr, $geo_clear, $input_mm_device_id)
        FLATTEN LIST BY (group_list as group_name, RegionsList as Regions)
    WHERE 
        tf = 1
        AND IF ($black_list_all, group_name not in black_group_list, true)
    GROUP BY
        $to_start_output(eventtime_ts) as `Date`,
        SessStart_ts as Visit_date,
        group_metrika as group_metrika,
        group_name as group_name,
        countertype as countertype,
        Regions as regions,
        type_group as type_group,
        device_type as device_type,
        campaign_type,
        content_type,
        product_category as product_category
    ;

    $good_date =
    SELECT 
        group_metrika,
        group_name,
        regions,
        max(`Date`) as max_dt,
        min(`Date`) as min_dt
    FROM $metriks_date
    WHERE 
        (Visits is not null
        OR duration is not null
        OR page_views is not null
        OR bounce is not null
        OR converted_session is not null
        OR EPurchases is not null
        OR Revenue is not null)
    GROUP BY
        group_metrika,
        group_name,
        regions
    ;

    $cross_dt =
    SELECT
        gd.group_metrika as group_metrika,
        gd.group_name as group_name,
        gd.regions as regions,
        dt.dt as dt
    FROM $date_table() as dt
    CROSS JOIN $good_date as gd
    WHERE 1=1
        AND gd.max_dt >= dt.dt
        AND dt.dt >= gd.min_dt
    ;

    SELECT 
        dt.dt as `Date`,
        dt.group_metrika as group_metrika,
        dt.group_name as group_name,
        type_group,
        dt.regions as regions,
        device_type,
        campaign_type,
        content_type,
        product_category,
        Visits ?? 0 as Visits,
        duration ?? 0.0 as duration,
        page_views ?? 0 as page_views,
        bounce ?? 0 as bounce,
        converted_session ?? 0 as converted_session,
        EPurchases ?? 0 as EPurchases,
        Revenue ?? 0.0 as Revenue
    FROM $cross_dt as dt
    LEFT JOIN $metriks_date as metriks
    ON dt.dt = metriks.`Date` AND dt.group_metrika = metriks.group_metrika AND dt.group_name = metriks.group_name AND dt.regions = metriks.regions
END DEFINE;

DEFINE SUBQUERY $black_test($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $input_metrica_currency_rates, $use_up_lift, $counter_and_goals, $time_filter, $filtred_metrika, $crypta_clear, $direct_clear, $date_start_curr, $geo_clear, $input_mm_device_id) AS 

    SELECT DISTINCT UserID, group_name
    FROM (  SELECT UserID, group_name
            FROM $ad_user_black($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)
            WHERE
                group_name is not null

            UNION ALL
            SELECT DISTINCT UserID, group_name
            FROM $pv_data_metrika($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $input_metrica_currency_rates, $use_up_lift, $counter_and_goals, $time_filter, $filtred_metrika, $crypta_clear, $direct_clear, $date_start_curr, $geo_clear, $input_mm_device_id)
            FLATTEN LIST BY (group_list as group_name)

            UNION ALL
            SELECT DISTINCT UserID, group_name
            FROM $pv_data_metrika($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $input_metrica_currency_rates, $use_up_lift, $counter_and_goals, $time_filter, $filtred_metrika, $crypta_clear, $direct_clear, $date_start_curr, $geo_clear, $input_mm_device_id)
            FLATTEN LIST BY (black_group_list as group_name)
        );

END DEFINE;

EXPORT 
    $data_path_pv_metrika,
    $pv_data_metrika,
    $black_test;
