use hahn;

IMPORT post_campaign_lib SYMBOLS 
    $name_geo_by_id
    ,$return_control_group
    ,$uniq_list
    ,$make_elements
    ;

IMPORT metrika SYMBOLS 
    $metrika;

------------------------------------------------------------------------------------------------------------------------
--                                              Контроль PV - старая версия
------------------------------------------------------------------------------------------------------------------------

DEFINE SUBQUERY $control_group_post_view($input_metrica_currency_rates, $date_start_curr, $use_up_lift, $filtred_metrika, $counter_and_goals, $crypta_clear, $input_qa_region_id, $regions_task, $control_group_o, $campaign_and_group) AS 

        SELECT
            $uniq_list($make_elements($campaign_and_group, 'category')) as group_list,
            group_metrika,
            control_group_list,
            VisitID,
            UserID,
            SessStart_ts,
            Duration,
            page_views,
            bounce,
            converted_session,
            EPurchases,
            Revenue,
            RegionsList,
        FROM $metrika($input_metrica_currency_rates, $date_start_curr, $use_up_lift, $filtred_metrika, $counter_and_goals, $crypta_clear) as m
        JOIN $input_qa_region_id as geo
            ON m.RegionID = geo.RegionID
        WHERE 
        ListHasItems($name_geo_by_id(geo.TargetRegionID, $regions_task))
        GROUP BY
            m.group_metrika as group_metrika,
            $name_geo_by_id(geo.TargetRegionID, $regions_task) as RegionsList,
            $return_control_group($control_group_o, m.gender, m.age, m.income, m.shortterm_interests, m.longterm_interests, m.heuristic_common) as control_group_list,
            m.VisitID as VisitID,
            m.UserID as UserID,
            m.SessStart_ts as SessStart_ts,
            m.Duration as Duration,
            m.page_views as page_views,
            m.bounce as bounce,
            m.converted_session as converted_session,
            m.EPurchases as EPurchases,
            m.Revenue as Revenue
        ;

END DEFINE;

EXPORT 
    $control_group_post_view
    ;
