use hahn;

PRAGMA AnsiInForEmptyOrNullableItemsCollections;

IMPORT connect_ad SYMBOLS 
    $ad_all_data;

IMPORT post_campaign_lib SYMBOLS 
    $return_control_group
    ,$name_geo_by_id
    ,$geo_name
    ,$uniq_list
    ,$make_elements
    ;
------------------------------------------------------------------------------------------------------------------------
--                                              Post-search формируем данные
------------------------------------------------------------------------------------------------------------------------

DEFINE SUBQUERY $search_data_post_view($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $regular_expression_on, $multi_match, $matcher, $control_group_o, $time_filter, $search_data, $geo_clear, $input_mm_device_id) AS 

        SELECT 
            UserID_ad,
            UserID_Search,
            control_group_list,
            black_group_list,
            reqid,
            group_list,
            region_list_Search,
            region_id_Search,
            Region_List_Ads,
            date_,
            category,
            time_of_search,
            IF ($time_filter(ad.eventtime_ts, s.time_of_search), 1, 0) as tf
        FROM $search_data() as s
        LEFT JOIN $ad_all_data($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id) as ad
            ON s.UserID = ad.UserID
        JOIN $input_qa_region_id as geo
            ON s.region_id = geo.RegionID
        GROUP BY 
            $return_control_group($control_group_o, s.gender, s.age, s.income, s.shortterm_interests, s.longterm_interests, s.heuristic_common) as control_group_list,
            ad.UserID as UserID_ad,
            s.UserID as UserID_Search,
            s.reqid as reqid,
            ad.eventtime_ts as eventtime_ts,
            s.time_of_search as time_of_search,
            ad.group_list as group_list,
            $name_geo_by_id(geo.TargetRegionID, $regions_task) as region_list_Search,
            s.region_id as region_id_Search,
            ad.RegionsList as Region_List_Ads,
            ad.black_group_list as black_group_list,
            s.date_ as date_,
            s.category as category
        ;

END DEFINE;


DEFINE SUBQUERY $data_path_search_pv($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $regular_expression_on, $multi_match, $matcher, $control_group_o, $time_filter, $start, $black_list_all, $to_start_output, $date_table, $search_data, $geo_clear, $input_mm_device_id) AS
$search_date_day = (
    SELECT 
        dt,
        category,
        groups,
        regions,
        COUNT (Distinct reqid) as pv_queries_count_all
    FROM $search_data_post_view($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $regular_expression_on, $multi_match, $matcher, $control_group_o, $time_filter, $search_data, $geo_clear, $input_mm_device_id)
    FLATTEN LIST BY (category, group_list as groups, Region_List_Ads as Regions_Ads)
    WHERE tf = 1
    AND $start <= cast(DateTime::MakeDate(time_of_search) as string)
    AND IF ($black_list_all, groups not in black_group_list, true)
    GROUP BY 
        $to_start_output(cast (date_ as date)) as dt,
        category,
        groups,
        Regions_Ads as regions
);

$categor_search = 
    (
    SELECT AGGREGATE_LIST_DISTINCT(category) as list_category
    FROM $search_data_post_view($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $regular_expression_on, $multi_match, $matcher, $control_group_o, $time_filter, $search_data, $geo_clear, $input_mm_device_id)
    );

$normal_date = (
    SELECT
        d.dt as dt,
        c.list_category as category
    FROM $categor_search as c
    CROSS JOIN $date_table() as d
)
;
$date_and_category = 
(
    SELECT dt as date_, categ, $geo_name($regions_task) as RegionsList, $uniq_list($make_elements($campaign_and_group, 'category')) as group_list
    FROM $normal_date
    FLATTEN BY category as categ
);

$date_and_region =
(
    SELECT date_, category, regions, groups
    FROM $date_and_category
    FLATTEN BY (RegionsList as Region, categ as category, group_list as groups)
    GROUP BY 
    date_, 
    groups,
    category, 
    Region as regions
);

$imperssion = (
    SELECT 
        date_,
        groups,
        regions,
        sum (Shows) as impression
    FROM $ad_all_data($regions_task, $campaign_and_group, $add_vat, $input_qa_region_id, $direct_clear, $crypta_clear, $geo_clear, $input_mm_device_id)
    FLATTEN BY (RegionsList as Region, group_list as groups)
    GROUP BY
        $to_start_output(eventtime_ts) as date_,
        Region as regions,
        groups
);

$all_search = 
SELECT 
d.groups as groups,
d.category as category,
d.regions as regions,
d.date_ as date_,
i.impression as impression,
s.pv_queries_count_all as pv_queries_count_all
FROM $date_and_region as d
LEFT JOIN $imperssion as i
ON d.date_ = i.date_ AND d.regions = i.regions AND d.groups = i.groups
LEFT JOIN $search_date_day as s
ON d.date_ = s.dt AND d.category = s.category AND d.regions = s.regions AND d.groups = s.groups
;

$gd =
    SELECT 
        max(date_) as max_date,
        min(date_) as min_date,
        groups,
        category,
        regions
    FROM $all_search
    GROUP BY
        groups,
        category,
        regions
    ;

SELECT
    gd.groups as groups,
    gd.category as category,
    gd.regions as regions,
    sear.date_ as date_,
    sear.impression ?? 0 as impression,
    sear.pv_queries_count_all ?? 0 as pv_queries_count_all
FROM $all_search as sear
JOIN $gd as gd
ON gd.groups =sear.groups and gd.category = sear.category and gd.regions = sear.regions
WHERE 1=1 
    AND max_date >= date_
    AND date_ >= min_date

END DEFINE;

EXPORT 
    $search_data_post_view,
    $data_path_search_pv
    ;
