------------------------------------------------------------------------------------------------------------------------
--                             Парсинг задания для post-campaign
------------------------------------------------------------------------------------------------------------------------
-- Парсинг периода из формы
$period_start = ($period_params) -> {RETURN Yson::LookupString($period_params, 'start')};
$period_end = ($period_params) -> {RETURN Yson::LookupString($period_params, 'end')};
$period_detail = ($period_params) -> {RETURN Yson::LookupString($period_params, 'scale')};

-- Парсинг в простые типы
$Yson_to_int = ($params) -> {RETURN cast (Yson::ConvertToString ($params) as Int32)};

-- Парсинг ГЕО
$region_parse = ($task_region) -> {
    RETURN ListMap(Yson::ConvertToList($task_region), ($region) -> {
        RETURN 
            (
                Yson::ConvertToString(Yson::LookupDict($region, 'rtregions')['name']) ?? '',
                ListMap(Yson::ConvertToUint64List(Yson::LookupDict($region, 'rtregions')['regions']), ($id) -> {RETURN CAST($id AS Int32) ?? -1})
            )
    })
};

-- Парсинг правил из формы для ADVQ метчера. Пребразует в строку, аналогичную yml формату
$category_rules_parse = ($task_rules) -> {
    $remove_empty = ($rules_list) -> {RETURN ListFilter($rules_list, ($rule) -> {RETURN $rule != "''"})};
    RETURN 
        String::JoinFromList(
            ListMap(Yson::ConvertToList($task_rules), ($yson_dict) -> {
                RETURN
                    Yson::LookupString($yson_dict, 'category_name') || ':\n  pos_phrases: [' || 
                    String::JoinFromList($remove_empty(ListMap(Yson::LookupList($yson_dict, 'pos_rules'), ($pos_rule) -> {
                        RETURN "'" || String::RemoveAll(Yson::ConvertToString($pos_rule), '\\') || "'"
                    })), ', ') 
                    || ']\n  neg_phrases: [' 
                    || String::JoinFromList($remove_empty(ListMap(Yson::LookupList($yson_dict, 'neg_rules'), ($neg_rule) -> {
                            RETURN "'" || Yson::ConvertToString($neg_rule) || "'"
                        })), ', ')
                    || ']'
                    || IF(Yson::LookupBool($yson_dict, 'advq_rules'), '\n  parser_name: advq', '') 
            }),
            '\n'
        )
};

-- Парсинг правил для регулярных выражений из формы
$re_match_parse = ($task_re_match) -> {
    RETURN
        String::JoinFromList(ListMap($task_re_match, ($rule) -> {RETURN '.*' || $rule || '.*' }), '|')
};

$clear_string = ($string_form) -> {
    RETURN (String::RemoveAll($string_form, ' '))
};

$parse_item = ($yson, $key) -> {
        RETURN 
            String::JoinFromList(
                ListMap(Yson::LookupList($yson, $key), ($list_element) -> {RETURN Yson::ConvertToString($list_element)}),
            ',') ?? ''
    };

--Парсинг групп объявлений из формы
$group_ad_parse = ($group_list) -> {
    RETURN ListMap(Yson::ConvertToList($group_list), ($group) -> {
        RETURN ToDict (
            [
                ('category', Yson::LookupString($group, 'category_name') ?? ''),
                ('campaign_ids', $clear_string($parse_item($group, 'campaign_ids')) ?? ''),
                ('group_ids', $clear_string($parse_item($group, 'group_ids')) ?? ''),
                ('geo', $clear_string($parse_item($group, 'geo')) ?? ''),
                ('ad_fox', $clear_string($parse_item($group, 'ad_fox')) ?? ''),
                ('black_campaign_ids', $clear_string($parse_item($group, 'black_campaign_ids')) ?? ''),
                ('black_group_ids', $clear_string($parse_item($group, 'black_group_ids')) ?? ''),
                ('black_geo', $clear_string($parse_item($group, 'black_geo')) ?? ''),
                ('black_ad_fox', $clear_string($parse_item($group, 'black_ad_fox')) ?? '')
            ]
        )
    })
};

-- преобразования данных из формы в листы со стрингами
$string_to_list = ($string) -> {
    RETURN cast (ListNotNull(IF ($string = '', null, String::SplitToList($string, ','))) as list<String>)
};

-- Парсинг контрольной группы из формы
$control_group_parse = ($control_group_form) -> {
    RETURN Cast (ListMap(Yson::ConvertToList($control_group_form), ($group) -> {
        RETURN ToDict (
            [
                ('control', $string_to_list(Yson::LookupString($group, 'control_group_name')) ?? ListCreate(List<String>)                    ),
                ('short', $string_to_list($clear_string(Yson::LookupString($group, 'short')) ?? '') ?? ListCreate(List<String>)              ),
                ('long', $string_to_list($clear_string(Yson::LookupString($group, 'long')) ?? '') ?? ListCreate(List<String>)                ),
                ('any', $string_to_list($clear_string(Yson::LookupString($group, 'any')) ?? '') ?? ListCreate(List<String>)                  ),
                ('married', $string_to_list($clear_string(Yson::LookupString($group, 'married')) ?? '') ?? ListCreate(List<String>)          ),
                ('kids', $string_to_list($clear_string(Yson::LookupString($group, 'kids')) ?? '') ?? ListCreate(List<String>)                ),
                ('prof', $string_to_list($clear_string(Yson::LookupString($group, 'prof')) ?? '') ?? ListCreate(List<String>)                ),
                ('gender',  ListNotNull(AsList(
                            IF (Yson::LookupBool($group, 'woman'),'f', NULL),
                            IF (Yson::LookupBool($group, 'man'),'m', NULL)
                            ))
                ),
                ('age', ListNotNull(AsList(
                        IF (Yson::LookupBool($group, 'age_0_17'), '0_17', NULL),
                        IF (Yson::LookupBool($group, 'age_18_24'), '18_24', NULL),
                        IF (Yson::LookupBool($group, 'age_25_34'), '25_34', NULL),
                        IF (Yson::LookupBool($group, 'age_35_44'), '35_44', NULL),
                        IF (Yson::LookupBool($group, 'age_45_54'), '45_54', NULL),
                        IF (Yson::LookupBool($group, 'age_55_99'), '55_99', NULL)
                        ))
                ),
                ('income',  ListNotNull(AsList(
                            IF (Yson::LookupBool($group, 'a'), 'A', NULL),
                            IF (Yson::LookupBool($group, 'b1'), 'B1', NULL),
                            IF (Yson::LookupBool($group, 'b2'), 'B2', NULL),
                            IF (Yson::LookupBool($group, 'c1'), 'C1', NULL),
                            IF (Yson::LookupBool($group, 'c2'), 'C2', NULL)
                            ))
                )
            ]
        )
    }) as List<Dict<String,List<String>>>)
};

$group_metrika_parse = ($group_list) -> {
    RETURN ListMap(Yson::ConvertToList($group_list), ($group) -> {
        RETURN ToDict (
            [
                ('category', Yson::LookupString($group, 'category_name') ?? ''),
                ('goal_ids', $clear_string(Yson::LookupString($group, 'goals')) ?? ''),
                ('counter_ids', $clear_string(Yson::LookupString($group, 'metrik')) ?? '')
            ]
        )
    })
};

$parse_permalink = ($table) -> {
    RETURN Cast (ListMap(Yson::ConvertToList($table), ($group) -> {
        RETURN ToDict (
            [
                ('org_name', AsList (Yson::LookupString ($group, 'dohodimost_name'))),
                ('link_name', ListMap(Yson::LookupList ($group, 'permalink_table'), ($name) -> {RETURN Yson::LookupString ($name, 'name')}))
            ]

        )
    }) as List<Dict<String,List<String>>>)
};

$parse_offline = ($table) -> {
    RETURN Cast (ListMap(Yson::ConvertToList($table), ($group) -> {
        RETURN ToDict (
            [
                ('org_name', Yson::LookupString ($group, 'dohodimost_name')),
                ('path', Yson::LookupString ($group, 'dohodimost_url_start')),
                ('date_type', Yson::LookupString ($group, 'date_type'))
            ]

        )
    }) as List<Dict<String,String>>)
};

$parse_date_format = ($type_date) -> {
    RETURN
        CASE
        WHEN $type_date = '%d%m%Y' THEN '%d%m%Y'
        WHEN $type_date = '%d.%m.%Y' THEN '%d.%m.%Y'
        WHEN $type_date = '%d-%m-%Y' THEN '%d-%m-%Y'
        WHEN $type_date = '%Y%m%d' THEN '%Y%m%d'
        WHEN $type_date = '%Y.%m.%d' THEN '%Y.%m.%d'
        WHEN $type_date = '%Y-%m-%d' THEN '%Y-%m-%d'
        ELSE ''
        END
};

-- Парсинг правил для регулярных выражений из формы
$re_match_parse = ($task_re_match) -> {
    RETURN
        String::JoinFromList(ListMap($task_re_match, ($rule) -> {RETURN '.*' || $rule || '.*' }), '|')
};

EXPORT 
    $period_start, 
    $period_end, 
    $period_detail,
    $group_ad_parse,
    $group_metrika_parse,
    $region_parse, 
    $category_rules_parse,
    $control_group_parse,
    $parse_permalink,
    $parse_offline,
    $parse_date_format,
    $re_match_parse,
    $Yson_to_int
;
