const os = require('os');

module.exports = {
    server: {
        port: process.env.QLOUD_HTTP_PORT || 8000,
        hostname: os.hostname()
    },

    static: {
        host: '/static',
        dir: `${__dirname}/../out/public`
    },

    app: {
        domains: 'ru'
    },

    view: {
        templateRoot: `${__dirname}/../out/static`,
        block: 'b-page',
        templateExt: 'bh',
        cwd: `${__dirname}/../out/static`,
        lang: 'ru'
    },

    csp: {
        policies: {
            'default-src': ["'none'"],
            'script-src': ["'self'", "'unsafe-eval'", "'unsafe-inline'", '%nonce%', 'yastatic.net', 'mc.yandex.ru'],
            'style-src': ["'self'", "'unsafe-inline'", 'yastatic.net', 'mc.yandex.ru'],
            'font-src': ["'self'", 'yastatic.net'],
            'img-src': ["'self'", 'data:', 'avatars.yandex.net', 'avatars.mds.yandex.net', 'avatars.mdst.yandex.net', 'mc.yandex.ru', 'yastatic.net'],
            'frame-src': ["'self'"],
            'child-src': ["'self'"],
            'connect-src': ["'self'", 'mc.yandex.ru']
        },
        useDefaultReportUri: true,
        serviceName: 'avatars'
    },

    uploadMdsUrl: '/upload-mds',
    uploadSocialUrl: '/upload-social',

    avatarService: {
        read: {
            protocol: 'https',
            hostname: 'avatars.mds.yandex.net'
        },
        write: {
            protocol: 'http',
            hostname: 'avatars-int.mds.yandex.net',
            port: 13000
        },
        putNamespace: 'put-adv'
    },

    mail: {
        smtp: 'yabacks.mail.yandex.net',
        from: 'noreply@yandex.ru',
        subject: 'Ошибка на avatars',
        to: [
            'advdev@yandex-team.ru'
        ]
    },

    share: {
        canvas: {
            width: 1200,
            height: 630
        },
        background: {
            color: '#E6E6E6'
        },
        veil: {
            color: 'rgba(0, 0, 0, $)'
        },
        text: {
            offsetX: 77,
            offsetY: 130,
            color: '#000',
            invertedColor: '#fff',
            font: 'Yandex Sans Text Medium',
            fontSize: 64,
            lineHeight: 80
        },
        url: {
            offsetX: 77,
            offsetY: 540,
            color: '#767676',
            invertedColor: '#fff',
            font: 'Yandex Sans Text Regular',
            fontSize: 32
        },
        logo: {
            offsetX: 933,
            offsetY: 497,
            path: 'images',
            logo: 'logo_original.png',
            invertedLogo: 'logo_inverted.png'
        }
    }
};
