'use strict';

const config = require('cfg');
const cookieParser = require('cookie-parser');
const express = require('express');
const expressBundleResponse = require('express-bundle-response');
const expressDomainAccess = require('express-domain-access');
const expressTld = require('express-tld');
const expressXff = require('express-x-forwarded-for-fix');
const expressYandexCsp = require('express-yandex-csp');
const helmet = require('helmet');
const morgan = require('morgan');

const commonData = require('./middlewares/commonData');

const app = express();

app.set('env', config.environment);
app.disable('x-powered-by');
app.disable('etag');
app.enable('trust proxy');

app.use('/static', express.static(config.static.dir, {
    fallthrough: false,
    maxAge: 365 * 24 * 60 * 60 * 1000
}));

app.use(morgan('combined'));

app.use(cookieParser());
app.use(expressXff());
app.use(expressYandexCsp(config.csp));

app.use(helmet.noSniff());
app.use(helmet.xssFilter({ setOnOldIE: true }));

app.use(expressTld());
app.use(expressDomainAccess(config.app.domains));
app.use(expressBundleResponse(config.view));

app.use(commonData());

require('./router')(app);

module.exports = app;
