'use strict';

const config = require('cfg');

const request = require('request-promise-native');

const mailer = require('../lib/mailer');

module.exports = (req, res) => {
    if (!req.file) {
        res.sendStatus(400);

        return;
    }

    const protocol = config.avatarService.write.protocol;
    const hostname = config.avatarService.write.hostname;
    const port = config.avatarService.write.port;
    const putNamespace = config.avatarService.putNamespace;

    const options = {
        method: 'POST',
        url: `${protocol}://${hostname}:${port}/${putNamespace}`,
        formData: {
            file: {
                value: req.file.buffer,
                options: {
                    filename: req.file.originalname,
                    contentType: req.file.mimetype
                }
            }
        }
    };

    request(options)
        .then(body => {
            try {
                res.send(JSON.parse(body));
            } catch (err) {
                mailer('mdsUpload.js:39<br><br>' + err);
                res.status(400).send(err.toString());
            }
        })
        .catch(err => {
            mailer('mdsUpload.js:44<br><br>' + err);
            res.status(err.statusCode || 400).send(err.toString());
        });
};
